package r09.r09_04;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexDemo {
    public static void main(String[] args) {
        System.out.printf("%-30s%-30s%-20s\n", "Wyrażenie regularne", "Wejście", "Dopasowania");
        showMatches("a", "Java");
        showMatches(".", "Java");
        showMatches("\\x{1D546}", "Oktoniony \uD835\uDD46");
        showMatches("\\uD835\\uDD46", "Oktoniony \uD835\uDD46");
        showMatches("\\n", "Witaj\nświecie");
        showMatches("\\cJ", "Witaj\nświecie");
        showMatches("\\\\", "c:\\windows\\system");
        showMatches("\\Q.\\E", "Witaj. Świecie.");
        showMatches("[A-Za-z]", "Pozna\u0144");
        showMatches("[^aeiou]", "Witaj");
        showMatches("[\\p{L}&&[^A-Za-z]]", "Pozna\u0144");
        showMatches("\\d", "100 lat");
        showMatches("\\w", "100 lat");
        showMatches("\\s*,\\s*", "Witaj, świecie");
        showMatches("(e|o).l", "Witaj, świecie");
        showMatches("(['\"]).*\\1", "Witaj, 'świecie'");
        showMatches("(?<quote>['\"]).*\\k<quote>", "Witaj, 'świecie'");
        showMatches("(?:[a-z]:)?([\\\\/])\\w+(\\1\\w+)*", "c:\\windows\\system i /bin");
        showMatches("(?i:jpe?g)", "JPEG, jpeg, JPG i jpg");
        showMatches("[0-9]{3,}", "100 lat");
        showMatches("<(.+?>).*</\\1", "<i>Witaj</i>, <b>świecie</b>!");
        showMatches("'[^']*+'", "Ten 'żart' nie jest śmieszny.");
        showMatches("\\G\\w+,\\s*", "Ateny, Rzym, Nowy Jork, Paryż");
        showMatches("\\p{Punct}", "Witaj, świecie!");
        showMatches("\\p{sc=Greek}", "2\u03C0r");
        showMatches("\\p{InLetterlike Symbols}", "Java\u2122");
        showMatches("\\pP", "Witaj, świecie!"); // Jednoliterowych właściwości można nie ujmować w znaki {}.
        showMatches("\\p{IsUppercase}", "Witaj, świecie!");
        showMatches("\\p{javaJavaIdentifierStart}", "100 lat");
    }
    
    public static void showMatches(String regex, String input) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        System.out.printf("%-30s%-30s", regex, input);
        while (matcher.find()) {
            String match = matcher.group();
            System.out.print(match + " ");
        }
        System.out.println();        
    }
}
