package r09.r09_01;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class StreamDemo {
    public static void main(String[] args) throws IOException {
        Path path = Path.of("zemsta.txt");
        try (InputStream in = Files.newInputStream(path)) {
            int firstByte = in.read();
            System.out.println("Pierwszy bajt: " + firstByte);
            byte[] moreBytes = new byte[1_000_000];
            int bytesRead = in.read(moreBytes);
            System.out.println("Wczytano bajtów: " + bytesRead);            
        }
        
        byte[] allBytes = Files.readAllBytes(path);
        var contents = new String(allBytes, StandardCharsets.UTF_8);
        System.out.println(contents.substring(0, 50) + "...");

        byte[] helloBytes = { 72, 101, 108, 108, 111, 10 };
        path = Path.of("test.txt");
        try (OutputStream out = Files.newOutputStream(path)) {
            out.write(helloBytes);
        }
        
        var url = new URL("http://horstmann.com/index.html");
        try (InputStream in = url.openStream()) {
            Files.copy(in, Path.of("index.html"), StandardCopyOption.REPLACE_EXISTING);
        }
        
        var in = new ByteArrayInputStream(helloBytes);
        int n;
        do {
            n = in.read();
            System.out.println(n);
        } while (n != -1); 

        var out = new ByteArrayOutputStream();
        out.write(helloBytes);    
        byte[] bytes = out.toByteArray();
        System.out.println(new String(bytes, StandardCharsets.UTF_8));
    }
}
