package r08.r08_12;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ReductionDemo {
    public static void main(String[] args) throws IOException {
        Integer[] digits = { 3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, 8, 9, 7, 9, 3, 2, 3, 8, 4, 6, 2, 6,
                4, 3, 3, 8, 3, 2, 7, 9, 5, 0, 2, 8, 8, 4, 1, 9, 7, 1, 6, 9, 3, 9, 9, 3, 7, 5, 1, 0,
                5, 8, 2, 0, 9, 7, 4, 9, 4, 4, 5, 9, 2, 3, 0, 7, 8, 1, 6, 4, 0, 6, 2, 8, 6 };
        Stream<Integer> wartości = Stream.of(digits);
        Optional<Integer> suma = wartości.reduce((x, y) -> x + y);
        System.out.println("suma: " + suma);

        wartości = Stream.empty();
        suma = wartości.reduce((x, y) -> x + y); // Lub wartości.reduce(Integer::sum);
        System.out.println("suma: " + suma);

        wartości = Stream.of(digits);
        Integer suma2 = wartości.reduce(0, (x, y) -> x + y);
        System.out.println("suma2: " + suma2);

        wartości = Stream.empty();
        Integer suma3 = wartości.reduce(0, (x, y) -> x + y);
        System.out.println("suma3: " + suma3);

        String contents = Files.readString(Path.of("zemsta.txt"));
        List<String> słowa = List.of(contents.split("\\PL+"));

        int wynik = słowa.stream().reduce(
                0, 
                (total, słowo) -> total + słowo.length(),
                (total1, total2) -> total1 + total2);

        System.out.println("wynik: " + wynik);
    }
}
