package r08.r08_11;

import static java.util.stream.Collectors.*;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

record Pair<S, T>(S first, T second) {}

record City(String name, String state, int population) {
}

public class DownstreamCollectors {
    public static Stream<City> readCities(String filename) throws IOException {
        return Files.lines(Path.of(filename)).map(l -> l.split(", ")).map(a -> new City(a[0], a[1], Integer.parseInt(a[2]))); 
    }
    
    public static Stream<String> codePoints(String s) {
        var result = new ArrayList<String>();
        int i = 0;
        while (i < s.length()) {
            int j = s.offsetByCodePoints(i, 1);
            result.add(s.substring(i, j));
            i = j;
        }
        return result.stream();
    }

    public static void main(String[] args) throws IOException {
        Stream<Locale> locales = Stream.of(Locale.getAvailableLocales());
        locales = Stream.of(Locale.getAvailableLocales());
        Map<String, Set<Locale>> krajeNaLokalizacjeZestaw = locales.collect(
           groupingBy(Locale::getCountry, toSet()));
        System.out.println("krajeNaLokalizacjeZestaw: " + krajeNaLokalizacjeZestaw);   

        locales = Stream.of(Locale.getAvailableLocales());
        Map<String, Long> krajeNaLokalizacjeCount = locales.collect(
           groupingBy(Locale::getCountry, counting()));
        System.out.println("krajeNaLokalizacjeCount: " + krajeNaLokalizacjeCount);   

        Stream<City> miasta = readCities("miasta.txt");
        Map<String, Integer> stanyNaLudnośćMiast = miasta.collect(
           groupingBy(City::state, summingInt(City::population)));
        System.out.println("stanyNaLudnośćMiast: " + stanyNaLudnośćMiast);

        miasta = readCities("miasta.txt");
        Map<String, Optional<City>> stanyNaNajwiększeMiasta = miasta.collect(
            groupingBy(City::state,
            maxBy(Comparator.comparing(City::population))));
        System.out.println("stanyNaNajwiększeMiasta: " + stanyNaNajwiększeMiasta);        
        
        miasta = readCities("miasta.txt");
        Map<String, Optional<String>> stanyNaNajdłuższąNazwęMiasta = miasta.collect(
           groupingBy(City::state, 
              mapping(City::name,
                 maxBy(Comparator.comparing(String::length)))));

        System.out.println("stanyNaNajdłuższąNazwęMiasta: " + stanyNaNajdłuższąNazwęMiasta);

        locales = Stream.of(Locale.getAvailableLocales());
        Map<String, Set<String>> krajeNaJęzyki = locales.collect(
           groupingBy(Locale::getDisplayCountry, 
              mapping(Locale::getDisplayLanguage,
                 toSet())));
        System.out.println("krajeNaJęzyki: " + krajeNaJęzyki);   

        miasta = readCities("miasta.txt");
        Map<String, Set<String>> punktyKodoweNaStan
            = miasta.collect(
                groupingBy(City::state,
                    flatMapping(c -> codePoints(c.name().toLowerCase()),
                        toSet())));
        System.out.println("punktyKodoweNaStan: " + punktyKodoweNaStan);   

        miasta = readCities("miasta.txt");
        Map<String, Set<City>> dużeMiastaNaStan
            = miasta.collect(
                groupingBy(City::state,
                    filtering(c -> c.population() > 500000,
                        toSet())));

        System.out.println("dużeMiastaNaStan: " + dużeMiastaNaStan);
        
        miasta = readCities("miasta.txt");
        Map<String, IntSummaryStatistics> stanNaSumęPopulacjiMiast = miasta.collect(
           groupingBy(City::state,
              summarizingInt(City::population)));
        System.out.println(stanNaSumęPopulacjiMiast.get("NY"));

        miasta = readCities("miasta.txt");
        Map<String, String> stanyNaNazwyMiast = miasta.collect(
           groupingBy(City::state,
              reducing("", City::name,
                 (s, t) -> s.length() == 0 ? t : s + ", " + t)));

        miasta = readCities("miasta.txt");
        stanyNaNazwyMiast = miasta.collect(
           groupingBy(City::state,
              mapping(City::name,
                 joining(", "))));
        System.out.println("stanyNaNazwyMiast: " + stanyNaNazwyMiast); 
        
        miasta = readCities("miasta.txt");
        Pair<List<String>, Double> wynik = miasta.filter(c -> c.state().equals("NV"))
           .collect(teeing(
              mapping(City::name, toList()), // Pierwszy kolektor strumieniowy
              averagingDouble(City::population), // Drugi kolektor strumieniowy
              (list, avg) -> new Pair<>(list,  avg))); // Funkcja łącząca        
        System.out.println("wynik: " + wynik); 
    }
}
