package r03.r03_01;

public class InstanceofDemo {
	public static void main(String[] args) {
		// Rzutowanie
		IntSequence sequence = new DigitSequence(1729);
		DigitSequence digits = (DigitSequence) sequence;
		System.out.println(digits.rest());
		if (Math.random() < 0.5)
			sequence = new SquareSequence();

		// To się nie uda — IntSequence nie jest typem nadrzędnym dla String.
		// String digitString = (String) sequence;

	    // Może zadziałać, a jeśli nie, wyrzucony zostanie wyjątek rzutowania klasy.
		SquareSequence squares = (SquareSequence) sequence;
		
		// Operator instanceof (starej daty)
		
		if (sequence instanceof DigitSequence) {
		    DigitSequence ds = (DigitSequence) sequence;
		    System.out.println(ds.rest());
		}
		
		// Instanceof z dopasowaywaniem wzorca
		if (sequence instanceof DigitSequence ds) {
		    // Można tu użyć zmiennej ds.
			System.out.println(ds.rest());
		}
		
		// Zmiennej można użyć w wyrażeniu logicznym.
		if (sequence instanceof DigitSequence ds && ds.rest() >= 100) {
			System.out.println(ds.rest());
		}
		
		// A także z operatorem warunkowym.
		double rest = sequence instanceof DigitSequence ds ? ds.rest() : 0;
		System.out.println(rest);
	}
}
