package r01.r01_08;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ArrayListDemo {
    public static void main(String[] args) {
        var friends = new ArrayList<String>();
        friends.add("Piotr");
        friends.add("Paweł");
        friends.remove(1);
        friends.add(0, "Paweł"); // Wstawia przed pozycją o numerze 0.
        System.out.println("friends=" + friends);
        String first = friends.get(0);
        System.out.println("first=" + first);
        friends.set(1, "Maria");
        for (int i = 0; i < friends.size(); i++) {
            System.out.println(friends.get(i));
        }
        
        ArrayList<String> people = friends;
        people.set(0, "Maria"); // W tym momencie frends.get(0) również zwróci "Maria".
        System.out.println("friends=" + friends);
        
        var copiedFriends = new ArrayList<>(friends);
        copiedFriends.set(0, "Fred"); // Nie zmienia obiektu friends.
        System.out.println("copiedFriends=" + copiedFriends);
        System.out.println("friends=" + friends);
        
        friends = new ArrayList<>(List.of("Piotr", "Paweł", "Maria"));
        String[] names = friends.toArray(new String[0]);
        System.out.println("names=" + Arrays.toString(names));               
        
        var moreFriends = new ArrayList<>(List.of(names));
        System.out.println("moreFriends=" + moreFriends);         
        
        Collections.reverse(friends);
        System.out.println("Po odwróceniu, friends=" + friends);
        Collections.shuffle(friends);
        System.out.println("Po wymieszaniu, friends=" + friends);
        Collections.sort(friends);        
        System.out.println("Po sortowaniu, friends=" + friends);
    }
}
