package checkBox;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Ramka z przykładową etykietą tekstową i polami wyboru 
 * reprezentującymi różne atrybuty czcionki
 */
public class CheckBoxFrame extends JFrame
{
   private JLabel label;
   private JCheckBox bold;
   private JCheckBox italic;
   private static final int FONTSIZE = 24;

   public CheckBoxFrame()
   {
      // Dodanie przykładowej etykiety

      label = new JLabel("Koń i żółw grali w kości z piękną ćmą u źródła.");
      label.setFont(new Font("Serif", Font.BOLD, FONTSIZE));
      add(label, BorderLayout.CENTER);

      // Nasłuchiwacz ustawiający atrybuty czcionki
      // etykiety zgodnie z ustawieniami pól wyboru

      ActionListener listener = event ->
         {
            int mode = 0;
            if (bold.isSelected()) mode += Font.BOLD;
            if (italic.isSelected()) mode += Font.ITALIC;
            label.setFont(new Font("Serif", mode, FONTSIZE));
         };

      // Dodanie pól wyboru
      var buttonPanel = new JPanel();

      bold = new JCheckBox("Pogrubienie");
      bold.addActionListener(listener);
      bold.setSelected(true);
      buttonPanel.add(bold);

      italic = new JCheckBox("Kursywa");
      italic.addActionListener(listener);
      buttonPanel.add(italic);

      add(buttonPanel, BorderLayout.SOUTH);
      pack();
   }
}
