package jaas;

import com.sun.security.auth.callback.*;
import java.io.*;
import java.security.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;

/**
 * Program uwierzytelnia użytkownika za pomocą własnego modułu logowania,
 * a następnie wykonuje SysPropAction, korzystając z pozwoleń użytkownika.
 * @version 1.1 2023-11-12
 * @author Cay Horstmann
 */
public class JAASTest
{
   public static void main(final String[] args)
   {
      CallbackHandler handler;
      if (args.length == 0) handler = new TextCallbackHandler();
      else
      {
         // Większość aplikacji dostarcza własne sposoby wczytywania nazwy użytkownika 
         // i hasła. W tym programie użytkownik podaje swoją nazwę w wierszu wywołania,
         // a hasło jest wpisywane później z poziomu konsoli.
         String username = args[0];
         Console console = System.console();
         char[] password = console.readPassword("Hasło: ");
         handler = new SimpleCallbackHandler(username, password);
      }
      
      try
      {
         var context = new LoginContext("Login1", handler);
         context.login();
         Subject subject = context.getSubject();
         for (Principal p : subject.getPrincipals())
         {
            System.out.println(p.getClass().getName() + " " + p.getName());
         }
         context.logout();
      }
      catch (LoginException e)
      {
         e.printStackTrace();
         Throwable cause = e.getCause();
         if (cause != null) cause.printStackTrace();         
      }
   }
}