package server;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Program implementujący prosty serwer nasłuchujący na porcie 8189
 * i wysyłający echo informacji otrzymanej od klienta.
 * @version 1.23 2023-08-16
 * @author Cay Horstmann
 */
public class EchoServer
{
   public static void main(String[] args) throws IOException
   {
      int port = args.length >= 1 ? Integer.parseInt(args[0]) : 8189;
      
      try (var s = new ServerSocket(port); // Utworzenie gniazda serwera
            Socket incoming = s.accept()) // Oczekiwanie na połączenie do klienta        
      {
         serve(incoming);
      }
   }
   
   public static void serve(Socket incoming) throws IOException
   {
      try (var in = new Scanner(incoming.getInputStream());         
         var out = new PrintWriter(incoming.getOutputStream(),
            true /* autoFlush */))
      {
         out.println("Witaj! Wpisz BYE, by zakończyć.");
            
         // Wysyła echo informacji otrzymanej od klienta
         boolean done = false;
         while (!done && in.hasNextLine())
         {  
            String line = in.nextLine();            
            out.println("Echo: " + line);            
            if (line.strip().equals("BYE"))
               done = true;
         }
      }
   }   
}
