package match;

import java.io.*;
import java.net.*;
import java.nio.charset.*;
import java.util.regex.*;

/**
 * Program wyświetlający wszystkie adresy URL na stronie WWW poprzez dopasowanie
 * wyrażenia regularnego opisującego znacznik <a href=...> języka HTML.
 * Uruchamianie: java match.HrefMatch adresURL
 * @version 1.03 2018-03-19
 * @author Cay Horstmann
 */
public class HrefMatch
{
   public static void main(String[] args)
   {
      try
      {
         // Pobiera URL z wiersza poleceń lub używa domyślnego
         String urlString;
         if (args.length > 0) urlString = args[0];
         else urlString = "http://openjdk.java.net/";

         // Wczytuje zawartość strony
         InputStream in = new URL(urlString).openStream();
         var input = new String(in.readAllBytes(), StandardCharsets.UTF_8);

         // Wyszukuje wszystkie wystąpienia wzorca
         var patternString = "<a\\s+href\\s*=\\s*(\"[^\"]*\"|[^\\s>]*)\\s*>";
         Pattern pattern = Pattern.compile(patternString, Pattern.CASE_INSENSITIVE);
         pattern.matcher(input)
            .results()
            .map(MatchResult::group)
            .forEach(System.out::println);
      }
      catch (IOException | PatternSyntaxException e)
      {
         e.printStackTrace();
      }
   }
}
