/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeDeserializer;

public class SqlDateTypeDeserializer
extends AbstractDateTimeDeserializer<Date> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_DATE.withZone(UTC);

    public SqlDateTypeDeserializer(JsonBindingModel model) {
        super(Date.class, model);
    }

    public SqlDateTypeDeserializer() {
        super(Date.class, null);
    }

    @Override
    protected Date fromInstant(Instant instant) {
        return new Date(instant.toEpochMilli());
    }

    @Override
    protected Date parseDefault(String jsonValue, Locale locale) {
        TemporalAccessor parsed = DEFAULT_FORMATTER.withLocale(locale).parse(jsonValue);
        return new Date(this.getInstant(parsed).toEpochMilli());
    }

    @Override
    protected Date parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        TemporalAccessor parsed = this.getZonedFormatter(formatter).parse(jsonValue);
        return new Date(this.getInstant(parsed).toEpochMilli());
    }

    private Instant getInstant(TemporalAccessor parsed) {
        LocalDate local = LocalDate.from(parsed);
        return local.atStartOfDay().atZone(ZoneId.of("UTC")).toInstant();
    }
}

