import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.MailMessage;
import com.oreilly.servlet.ParameterParser;
import com.oreilly.servlet.ServletUtils;

public class MailServlet extends HttpServlet {

  static final String FROM = "MailServlet";
  static final String TO = "komentarze@wazna-firma.pl";

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    res.setContentType("text/plain; charset=ISO-8859-2");
    PrintWriter out = res.getWriter();

    ParameterParser parser = new ParameterParser(req);
    String from = parser.getStringParameter("from", FROM);
    String to = parser.getStringParameter("to", TO);

    try {
      MailMessage msg = new MailMessage();  // przyjcie localhost
      msg.from(from);
      msg.to(to);
      msg.setSubject("Komentarz klienta");

      PrintStream body = msg.getPrintStream();

      Enumeration enum = req.getParameterNames();
      while (enum.hasMoreElements()) {
        String name = (String)enum.nextElement();
        if (name.equals("to") || name.equals("from")) continue; // Pomi to/from
        String value = parser.getStringParameter(name, null);
        body.println(name + " = " + value);
      }

      body.println();
      body.println("---");
      body.println("Wysany przez " + HttpUtils.getRequestURL(req));

      msg.sendAndClose();

      out.println("Dzikujemy za komentarz...");
    }
    catch (IOException e) {
      out.println("Wsytpi problem z przesyaniem...");
      log("Wsytpi problem z przesyaniem", e);
    }
  }
}
