import com.go.teaservlet.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class NameContext {

  ApplicationRequest request;
  ApplicationResponse response;
  String name;

  public NameContext(ApplicationRequest request,
                     ApplicationResponse response) {
    this.request = request;
    this.response = response;
  }

  public String getName() {    
    // Jeeli nazwa wczeniej okrelona, zwrcenie jej
    if (name != null) { 
      return name;
    }
    
    // Prba okrelenia nazwy uytkownika
    name = request.getRemoteUser();
    
    // Jeeli nazwa logowania nie jest dostpna, prba odczytania parametru    
    if (name == null) {
      name = request.getParameter("name");
    }
    
    // Jeeli nazwa nie jest dostpna jako parametr, prba sesji
    if (name == null) {
      name = (String) request.getSession().getAttribute("name");
    }
    
    // Jeeli nazwy nie ma w sesji, prba cookie    
    if (name == null) {
      Cookie[] cookies = request.getCookies();
      for (int i = 0; i < cookies.length; i++) {
        if (cookies[i].getName().equals("name")) {
          name = cookies[i].getValue();
        }
      }
    }
    
    // Jeeli nazwy nie ma te w sesji, poddanie si
    return name;
  }
}
