import java.io.*;
import java.net.*;
import java.util.*;
import java.util.zip.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.oreilly.servlet.ServletUtils ;

public class ViewResourceCompress extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                   throws ServletException, IOException {
   OutputStream out = null;

   // Wybierz waciwe kodowanie zawartoci oparte na
   // nagwku klienta Accept-Encoding. Wybierz GZIP jeeli nagwek
   // zawiera "gzip". Wybierz ZIP jeeli nagwek zawiera "compress".
   // W przeciwnym wypadku nie wybieraj adnej kompresji. Upewnij si,  
   // e Content-Encoding wykorzystuje przedrostek "x-" wtedy i 
   // tylko wtedy jeeli robi to Accept-Encoding.
   String encodings = req.getHeader("Accept-Encoding");
   if (encodings != null && encodings.indexOf("gzip") != -1) {
      //Startuj z  GZIP
      if (encodings.indexOf("x-gzip") != -1) {
        res.setHeader("Content-Encoding", "x-gzip") ;
      }
      else {
        res.setHeader("Content-Encoding ", "gzip") ;
      }
   out = new GZIPOutputStream(res.getOutputStream()) ;

   }   
   else if (encodings != null && encodings.indexOf("compress") != -1) {
     // Startuj z ZIP
     if (encodings.indexOf("x-compress") != -1) {
       res.setHeader("Content-Encoding", "x-compress");
     }
     else {
       res.setHeader("Content-Encoding", "compress");
     }
     out = new ZipOutputStream(res.getOutputStream());
     ((ZipOutputStream)out).putNextEntry(new ZipEntry("nazwa pusta"));
   }
   else {
     // Nie kompresuj
     out = res.getOutputStream() ;
   }
   res.setHeader("Vary", "Accept-Encoding") ;

   // Pobierz zasb do przegldania
   URL url = null;
  try {
   url=ServletUtils.getResource(getServletContext(), req.getPathInfo());
}
catch (IOException e) {
   res.sendError(
      res.SC_NOT_FOUND,
  "Informacje dodatkowej cieki musz wskazywa na poprawny zasb do przegldania: " +
    e.getMessage());
}

// Pocz z zasobem
URLConnection con = url.openConnection();
con.connect() ;

// Pobierz i ustal typ zasobu
String contentType = con.getContentType();
res.setContentType(contentType);

// Zwr zasb
try {
   ServletUtils.returnURL(url, out);
}
catch (IOException e)  {
   res.sendError(res.SC_INTERNAL_SERVER_ERROR,
          "Problem przy przesyaniu zasobu: " + e.getMessage());
}

// Pisz znak koczcy i zamknij strumie wyjciowy
   out.close();
   }
 }
