import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.CacheHttpServlet;

public class Guestbook  extends CacheHttpServlet {

  private Vector entries = new Vector();  // Lista wpisw uytkownika
   private long lastModified = 0;      // Czas, w ktrym zosta
                                                        // dodany ostatni wpis

 // Wywietl aktualne wpisy, nastpnie popro o nowy wpis
  public  void doGet (HttpServletRequest req, HttpServletResponse res)
                             throws  ServletException,    IOException  {
    res.setContentType ("text/html; charset=ISO-8859-2");
    PrintWriter out  = res.getWriter();

    printHeader(out);
    printForm(out);
    printMessages(out);
    printFooter(out);
 }
   
    // Dodaj nowy wpis, nastpnie odelij z powrotem do doGet()
      public  void doPost (HttpServletRequest  req, HttpServletResponse res)
                         throws  ServletException, IOException  {
     handleForm(req, res);
     doGet(req, res);
 }

 private void printHeader(PrintWriter out) throws ServletException {
   out.println ("<HTML><HEAD><TITLE>Guestbook</TITLE></HEAD>");
   out.println ("<BODY>");
 }
 
 private void printForm(PrintWriter out) throws ServletException {
    out.println ("<FORM METHOD=POST>");   // przesya do siebie
    out.println ("<B>Prosz przelij swoje informacje:</B><BR>"); 
    out.println ("Twoje imi i nazwisko:<INPUT TYPE=TEXT NAME=name><BR>");
    out.println ("Twj e-mail: :<INPUT TYPE=TEXT NAME=email><BR>");
    out.println ("Komentarz: <INPUT TYPE=TEXT SIZE=50 NAME=comment><BR>");
    out.println ("<INPUT TYPE=SUBMIT VALUE=\"Przelij informacje\"><BR>");
    out.println ("</FORM>");
    out.println ("<HR>");
}

private void printMessages(PrintWriter out) throws ServletException {

   String name, email, comment;

  Enumeration e = entries.elements();
   while (e.hasMoreElements()) {
      GuestbookEntry entry = (GuestbookEntry)e.nextElement();
      name = entry.name;
      if (name == null) name  = "Nieznany uytkownik";
      email = entry.email;
      if(email == null) email = "Nieznany e-mail";
      comment = entry.comment;
      if (comment == null) comment = "Bez komentarza";
      out.println ("<DL>");
      out.println ("<DT><B>" + name + "</B> (" + email +") mwi");
     out.println ("<DD><PRE>" + comment + "</PRE>");
     out.println ("</DL>");

  // Wstrzymaj wykonywanie na p sekundy w celu symulacji
   // powolnego rda danych
    try {Thread.sleep(500);} catch  (InterruptedException ignored) { }
  }
 }

private void printFooter(PrintWriter out) throws ServletException {
    out.println ("</BODY>");
}

private   void handleForm (HttpServletRequest  req, 
    HttpServletResponse res) {

   GuestbookEntry entry =  new GuestbookEntry();

   entry.name = req.getParameter("name");
   entry.email = req.getParameter("email");
   entry.comment = req.getParameter("comment");
   entries.addElement(entry);

   // Zwr uwag, e mamy nowy czas ostatniej modyfikacji
   lastModified = System.currentTimeMillis();
 }

 
   public long getLastModified (HttpServletRequest  req) {
       return lastModified;
  }
}

class GuestbookEntry {
  public String name;
  public String email;
  public String comment;
}
