import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class SearchLogic extends HttpServlet {

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {    
    // Typ zawartoci ani writer nie jest okrelony
    
    // Pobranie acucha do poszukiwa
    String search = req.getParameter("search");
    
    // Utworzenie URL-i zawierajcych atrybut dania
    String[] results = getResults(search);
    
    // Okrelenie wynikw jako atrybutu dania
    req.setAttribute("results", results);

    // Przekazanie do strony wywietlajcej
    String display = "/servlet/SearchView";
    RequestDispatcher dispatcher = req.getRequestDispatcher(display);
    dispatcher.forward(req, res);
  }

  // W prawdziwym zastosowaniu metoda ta wywoywaaby waciw logik wyszukiwarki
  // i zwracaaby wiksz ilo informacji na temat kadego wyniku ni zwyky URL
  String[] getResults(String search) {
    return new String[] { "http://www.abc.com",
                          "http://www.xyz.com" };
  }
}
