import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.registry.*;
import java.rmi.server.*;
import java.util.*;

public class RMIChatApplet extends Applet implements ChatClient {

  TextArea text;
  Label label;
  TextField input;
  Thread thread;
  String user;

  ChatServer chatServer;

  private int getRegistryPort() {
    try { return Integer.parseInt(getParameter("port")); }
    catch (NumberFormatException ignored) { return Registry.REGISTRY_PORT; }
  }

  private String getRegistryName() {
    String name = getParameter("name");
    return (name == null ? "ChatServlet" : name);
  }

  // Zwraca referencj do zdalnego chatu serwer/serwlet
  // Prbuje wyj, jeeli wystpi problem
  private ChatServer getChatServer() {
    try {
      Registry registry =
        LocateRegistry.getRegistry(getCodeBase().getHost(), getRegistryPort());
      Object obj = registry.lookup(getRegistryName());
      return (ChatServer)obj;
    }
    catch (java.rmi.UnknownHostException e) {      
      // Nieznany komputer, prba wyjcia
      System.out.println("Komputer nieznany, URL: " + e.getMessage());
      System.exit(1);
    }
    catch (NotBoundException e) {      
      // Odnalezienie obiektu niemoliwe, prba wyjcia
      System.out.println("Nazwa niezwizana: " + e.getMessage());
      System.exit(1);
    }
    catch (ClassCastException e) {      
      // Obiekt to nie ChatServer, prba wyjcia
      System.out.println(getRegistryName() + " to nie ChatServer:" +
                         e.getMessage());
      System.exit(1);
    }
    catch (RemoteException e) {      
      // Oglny problem RMI, prba wyjcia
      System.out.println("Wyjtek zdalny: " + e.getMessage());
      System.exit(1);
    }
    catch (Exception e) {      
      // Inny problem, prba wyjcia
      System.out.println("Oglny wyjtek: " +
        e.getClass().getName() + ": " + e.getMessage());
      System.exit(1);
    }
    return null;  // zwraca null, jeeli exit() nie powiedzie si
  }

 
  // Dodanie siebie jako klienta serwera chat
  // Prosz zauway, e rejestr RMI nie jest potrzebny
  private void registerWithChatServer(ChatServer server) {
    try {
      UnicastRemoteObject.exportObject(this);
      server.addClient(this);
    }
    catch (RemoteException e) {      
      // Oglny problem RMI, prba wyjcia
      System.out.println("Wyjtek zdalny: " + e.getMessage());
      System.exit(1);
    }
    catch (Exception e) {      
      // Inny problem, prba wyjcia
      System.out.println("Oglny wyjtek: " +
        e.getClass().getName() + ": " + e.getMessage());
      System.exit(1);
    }
  }

  public void init() {
    // Sprawdzenie, czy aplet zosta pobrany bezporednio z systemu plikw.
    // Jeeli tak, wyjanienie uytkownikowi, e musi on by pobrany z serwera w celu 
    // komunikacji z serwletami tego serwera

    URL codebase = getCodeBase();
    if (!"http".equals(codebase.getProtocol())) {
      System.out.println();
      System.out.println("*** Ups! ***");
      System.out.println("Ten aplet musi by pobrany z serwera WWW.");
      System.out.println("Prosz sprbowa ponownie, tym razem adujc plik HTML");
      System.out.println("zawierajcy ten serwlet jako");
      System.out.println("\"http://serwer:port/plik.html\".");
      System.out.println();
      System.exit(1);  // Dziaa jedynie z appletwiever
                       // Przegldarki zgaszaj bd i kontynuuj
                       
    }
    
    // Pobranie zdalnego serwera chat
    chatServer = getChatServer();
    
    // Zarejestrowanie siebie jako jednego z klientw
    registerWithChatServer(chatServer);

    // Pobranie nazwy tego uytkownika z parametru apletu ustawionego przez serwlet
    // Mona o to po prostu spyta uytkownika, ale jest to przedstawienie formy
    // komunikacji serwlet->aplet.
    user = getParameter("user");
    if (user == null) user = "anonymous";

    // konfiguracja interfejsu uytkownika...
    // Na grze due pole TextArea przedstawiajce ca rozmow.
    // Poniej opisane TextField przyjmujce wpisy tego uytkownika.
    text = new TextArea();
    text.setEditable(false);
    label = new Label("Powiedz co: ");
    input = new TextField();
    input.setEditable(true);

    setLayout(new BorderLayout());
    Panel panel = new Panel();
    panel.setLayout(new BorderLayout());

    add("Center", text);
    add("South", panel);

    panel.add("West", label);
    panel.add("Center", input);
  }

  String getNextMessage() {
    String nextMessage = null;
    while (nextMessage == null) {
      try {
        nextMessage = chatServer.getNextMessage();
      }
      catch (RemoteException e) {
        // Wyjtek zdalny, zgoszenie i odczekanie przed nastpn prb
        System.out.println("Remote Exception:" + e.getMessage());
        try { Thread.sleep(1000); } catch (InterruptedException ignored) { }
      }
    }
    return nextMessage + "\n";
  }

  public void setNextMessage(String message) {
    text.appendText(message + "\n");
  }

  void broadcastMessage(String message) {
    message = user + ": " + message;  // Dodanie na pocztku nazwy klienta
    try {
      chatServer.broadcastMessage(message);
    }
    catch (RemoteException e) {      
      // Wyjtek zdalny zgoszenie i zaprzestanie nadawania
      System.out.println("Wyjtek zdalny: " + e.getMessage());
    }
    catch (Exception e) {      
      // Inny wyjtek, zgoszenie i zaprzestanie nadawania
      System.out.println("Oglny wyjtek: " +
        e.getClass().getName() + ": " + e.getMessage());
    }
  }

  public boolean handleEvent(Event event) {
    switch (event.id) {
      case Event.ACTION_EVENT:
        if (event.target == input) {
          broadcastMessage(input.getText());
          input.setText("");
          return true;
        }
    }
    return false;
  }
}
