import java.awt.* ;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.ServletUtils;

import Acme.JPM.Encoders.*;

public class DeColorize extends HttpServlet {

public void doGet(HttpServletRequest req, HttpServletResponse res)
                  throws ServletException, IOException {
   res.setContentType("image/gif") ;
   ServletOutputStream out = res.getOutputStream();

   // Pobierz lokalizacj obrazka z informacji cieki
   URL source = ServletUtils.getResource(getServletContext(),
            req.getPathInfo()) ;

   if (source == null) {
      res.sendError(res.SC_NOT_FOUND,
      "Informacja dodatkowej cieki musi wskazywa na obrazek");
   return;
   }

   // Skonstruuj niewywietlan ramk
   // addNotify()nie wystpuje poniewa nie jest potrzebny
   Frame frame = new Frame () ;

   // aduj obrazek
   Image image = Toolkit.getDefaultToolkit().getImage(source);
   MediaTracker mt = new MediaTracker(frame);
   mt. addImage (image, 0);
   try {
       mt .waitForAll() ;
   }
   catch (InterruptedException e) {
      res. sendError (res. SC_INTERNAL_SERVER_ERROR,
         "Przerwano podczas adowania pliku: " +
         e.getMessage()) ;
   return;
}

   // Pobierz rozmiar obrazka
   int width = image.getWidth( frame) ;
   int height = image.getHeight(frame);

   // Upewnij si, e odczytujemy poprawne dane
   if (width <= 0 || height <= 0) {
     res.sendError(res.SC_NOT_FOUND,
         "Informacje dodatkowej cieki musz wskazywa na poprawny obrazek") ;
   return;
}

   // Utwrz obrazek, zastosuj filtr
   Image filtered = frame.createImage(
      new FilteredImageSource(image.getSource(),
                              new GrayscaleImageFilter()));

   //Zakoduj i zwr przefiltrowany obrazek
   GifEncoder encoder = new GifEncoder(filtered, out);
   encoder.encode() ;
  }
}
