import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ExportRestriction extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                           throws ServletException, IOException {
      res.setContentType("text/html; charset=ISO-8859-2") ;
      PrintWriter out = res.getWriter();

      // ...Troch wstpnego HTML-u...

      // Pobierz nazw komputera klienta
      String remoteHost = req.getRemoteHost() ;

      // Zobacz czy klient ma przyznany dostp
      if (! isHostAllowed(remoteHost)) {
          out.println("Dostp <BLINK>nie przyznany</BLINK>") ;
      }
      else {
         out.println("Dostp przyznany") ;
         // Wywietl odnoniki pobierania, itp.
   }
}

// Nie przyznawaj dostpu komputerom gwnym o zakoczeniach
//  .cu, .ir, .iq, .kp, .ly, .sy, and .sd.
private boolean isHostAllowed(String host){
   return (!host.endsWith(".cu") &&
              !host.endsWith(".cu") &&
              !host.endsWith(".ir")&&
              !host.endsWith(".iq")&&
              !host.endsWith(".kp")&&
              !host.endsWith(".ly")&&
              !host.endsWith(".sy")&&
              !host.endsWith(".sd"));
   }
}
