import java.io.*;
import java.net.*;
import java.rmi.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.RemoteDaemonHttpServlet;

public class ChatServlet extends RemoteDaemonHttpServlet
                         implements ChatServer {

  
  // rdo dziaa jako dystrybutor nowych wiadomoci
  MessageSource source = new MessageSource();

  // socketClients przechowuje refrencje do wszystkich klientw
  // czcych si przez gniazda
  Vector socketClients = new Vector();

  // rmiClients przechowuje referencje do wszystkich klientw 
  // czcych si przez RMI
  Vector rmiClients = new Vector();
  
  // doGet() zwraca nastpn wiadomo.  Blokuje dopki ona nie wystpi.
  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    res.setContentType("text/plain; charset=ISO-8859-2");
    PrintWriter out = res.getWriter();

    // Zwrcenie nastpnej wiadomoci (blokujce)
    out.println(getNextMessage());
  }

  // doPost() accepts a new message and broadcasts it to all
  // the currently listening HTTP and socket clients.
  // doPost() przyjmuje now wiadomo i wysya j do wszystkich
  // aktualnie nasuchujcych klientw czcych si przez HTTP i gniazda.
  public void doPost(HttpServletRequest req, HttpServletResponse res)
                                throws ServletException, IOException {
    //// Przyjcie wiadomoci jako parametru  "message"
    String message = req.getParameter("message");
    
    // Wysanie jej do wszystkich nasuchujcych klientw
    if (message != null) broadcastMessage(message);
    
    // Ustawienie kodu stanu aby zaznaczy, e nie bdzie odpowiedzi
    res.setStatus(res.SC_NO_CONTENT);
  }

  // getNextMessage() zwraca nastpn now wiadomo.
  // Blokuje dopki ona nie wystpi.

  public String getNextMessage() {    
    // Stworzenie pojemnika na wiadomoci czekajcego na now wiadomo
    // ze rda wiadomoci

    return new MessageSink().getNextMessage(source);
  }

  // broadcastMessage() informuje wszystkich aktualnie nasuchujcych klientw 
  // e jest nowa wiadomo.  Powoduje odblokowanie wszystkich wywoa do 
  // getNextMessage().

  public void broadcastMessage(String message) {    
    // Wysanie wiadomoci do wszystkich klientw HTTP poprzez przekazanie 
    // wiadomoci do rda wiadomoci
    source.sendMessage(message);
        
    // Bezporednie wysanie wiadomoci do wszystkich klientw poczonych 
    // przez gniazdo
    Enumeration enum = socketClients.elements();
    while (enum.hasMoreElements()) {
      Socket client = null;
      try {
        client = (Socket)enum.nextElement();
        PrintStream out = new PrintStream(client.getOutputStream());
        out.println(message);
      }
      catch (IOException e) {       
        // Problem z klientem, zamknicie i oddalenie go
        try {
          if (client != null) client.close();
        }
        catch (IOException ignored) { }
        socketClients.removeElement(client);
      }
    }

    // Bezporednie wysanie wiadomoci do wszystkich klientw RMI
    enum = rmiClients.elements();
    while (enum.hasMoreElements()) {
      ChatClient chatClient = null;
      try {
        chatClient = (ChatClient)enum.nextElement();
        chatClient.setNextMessage(message);
      }
      catch (RemoteException e) {        
        // Problem z komunikacj z klientem, usunicie go
        deleteClient(chatClient);
      }
    }
  }

  protected int getSocketPort() {    
    // Nasuchiwanie na porcie 2428 (prosz spojrze na telefon, dlaczego)
    return 2428;
  }

  public void handleClient(Socket client) {    
    // Nowy klient czcy si przez gniazdo. Dodanie go do listy.
    socketClients.addElement(client);
  }

  public void addClient(ChatClient client) {    
    // Nowy klient RMI. Dodanie go do listy.
    rmiClients.addElement(client);
  }

  public void deleteClient(ChatClient client) {    
    // Usunicie wybranego klienta z listy.
    rmiClients.removeElement(client);
  }
}

// ZrodloWiadomosc dziaa jako rdo nowych wiadomoci.
// Klienci zainteresowani przyjmowaniem nowych wiadomoci mog obserwowa 
// ten obiekt
class MessageSource extends Observable {
  public void sendMessage(String message) {
    setChanged();
    notifyObservers(message);
  }
}


// MessageSink  dziaa jako odbierajcy nowe wiadomoci.
// Nasuchuje rda.
class MessageSink implements Observer {

  String message = null;   // ustawienie przez update() I odczytanie 
                            // przez  getNextMessage()
                           
  
  // Wywoywany przez rdo wiadomoci kiedy odbiera now wiadomo
  synchronized public void update(Observable o, Object arg) {    
    // odebranie nowej wiadomoci
    message = (String)arg;
    
    // Obudzenie czekajcego wtku
    notify();
  }
  
  // Pobranie nastpnej wiadomoci wysanej ze rda wiadomoci
  synchronized public String getNextMessage(MessageSource source) {    
    // Powiedz rdu, e ma powiadamia o nowych wiadomociach
    source.addObserver(this);
    
    // Czekanie a metoda update() odbierze wiadomo    
    while (message == null) {
      try { wait(); } catch (Exception ignored) { }
    }
      
    // Powiedz rdu eby przestao informowa o nowych wiadomociach
    source.deleteObserver(this);
    
    // Zwrcenie otrzymanej wiadomoci
    // ale wczeniej ustawienie zmiennej egzemplarza wiadomoci na null
    // aby mogy zosta wywoane ponownie update() i getNextMessage().

    String messageCopy = message;    
    message = null;
    return messageCopy;
  }
}
