import java.awt.*;
import java.io.*;
import java.net.* ;
import javax.servlet.* ;
import javax.servlet.http.*;

import com.oreilly.servlet.ServletUtils;

import Acme.JPM.Encoders.GifEncoder;

public class Confidentializer extends HttpServlet { 
   Frame frame = null; 

public void init() throws ServletException { 
   // Skonstruuj niewywietlan ramk wielokrotnego uytku 
   frame = new Frame(); 
   frame.addNotify() ; 
}   
 
public void doGet (HttpServletRequest req, HttpServletResponse res) 
                     throws ServletException, IOException { 
   ServletOutputStream out = res.getOutputStream(); 
   Graphics g = null; 
 
try { 
   // Pobierz lokalizacj obrazka z informacji cieki
   // Dla bezpieczestwa uyj ServletUtils (Rozdzia 4) 
   URL source =
     ServletUtils.getResource(getServletContext(), req.getPathInfo()) ;

   // aduj obrazek do obiektu klasy Image
MediaTracker mt = new MediaTracker(frame); // ramka dziaa jako ImageObserver
Image image = Toolkit.getDefaultToolkit().getImage(source);

mt.addImage(image, 0) ;
try {
   mt .waitForAll();
}
catch (InterruptedException e) {
   res.sendError(res.SC_INTERNAL_SERVER_ERROR,
      "Przerwano podczas adowania obrazka");
return;
}

// Pobierz szeroko oraz dugo
int w = image.getWidth(frame) ;
int h = image.getHeight(frame);

// Upewnij si, e odczytujemy poprawne dane obrazka
if (w <= 0  || h <= 0) {
   res.sendError(res.SC_NOT_FOUND,
     "Informacje dodatkowej cieki musz wskazywa na poprawny obrazek");
return;
}

// Skonstruuj odpowiedni rozmiar poza-ekranowego kontekstu grafiki
Image offscreen = frame.createImage (w, h);
g = offscreen.getGraphics();

// Rysuj obrazek do poza-ekranowego kontekstu grafiki
g.drawImage( image, 0, 0, frame);

// Napisz POUFNE na jego powierzchni
  g.setFont(new Font("Monospaced", Font.BOLD | Font.ITALIC, 30));
  g.drawString("POUFNE", 10, 30);

  // Zakoduj poza-ekranow grafik do GIF i przelij j do klienta
  res.setContentType("image/gif") ;
  GifEncoder encoder = new GifEncoder(offscreen, out);
  encoder.encode();
}
finally {
// Zwolnij zasoby
   if (g != null) g.dispose();
 }
}

public void destroy() {
   // Zwolnij zasoby
   if (frame != null) frame.removeNotify() ;
 }
}
