import java.io.*;
import java.net.*;
import java.util.* ;
import javax.servlet.*;

public class KeyedServerLock extends GenericServlet {

   // Serwlet ten nie ma klasy ani zmiennej
   // zwizanej z blokowaniem (celem uproszczenia zagadnie 
   // zwizanych z synchronizacj)

   public void service(ServletRequest req, ServletResponse res)
                              throws ServletException, IOException {
      res.setContentType("text/plain; charset=ISO-8859-2") ;
      PrintWriter out = res.getWriter();

      // Kontrola antypiracka nie powinna by wykonywana w init
      // poniewa nazwa/port s czci zlecenia.
      String key = getInitParameter("key");
      String host = req.getServerName();
      int port = req.getServerPort();

      // Sprawd czy parametr pocztkowy key odblokowuje ten serwer.
      if (!keyFitsServer(key, host, port)) {
         // Wyjanij, potp, zagr, itd.
         out.println("Kopia piracka!");
      }
      else {
         // Dostarcz towar
         out.println("Kopia licencjonowana");
         // itd...
      }
   }

   // Metoda ta zawiera algorytm uywany do dopasowania klucza z 
   // nazw komputera i portem. Niniejszy przykad implementacji 
   // jest dalece nie doskonay i nie powinien by uywany przez
   // strony komercyjne.

   private boolean keyFitsServer(String key, String host, int port) {
      if (key == null) return false;

      long numericKey = 0;
      try {
         numericKey = Long.parseLong(key);
      }
      catch (NumberFormatException e) {
        return false;
      }

      // Klucz musi by liczb 64-bitow rwn logicznej negacji (~)
      // 32-bitowego adresu IP poczonego z 32-bitowym numerem portu.

      byte hostIP[] ;
      try {
         hostIP = InetAddress.getByName(host).getAddress();
      }
      catch (UnknownHostException e) {
        return false;
      }

       // Pobierz 32-bitowy adres IP
       long servercode = 0;
       for (int i = 0; i < 4; i++) {
          servercode <<= 8;
          servercode |= hostIP[i];
       }

       // Pocz 32-bitowy numer portu
       servercode <<= 32;
       servercode |= port;

      // logiczna negacja
      long accesscode = ~numericKey;

      // Moment prawdy: Czy klucz pasuje?
      return (servercode == accesscode);
    }
  }
