import java.io.*;
import java.net.*;
import java.util.*;

public class HttpClient {

  private static void printUsage() {
    System.out.println("uycie: java HttpClient host port");
  }

  public static void main(String[] args) {
    if (args.length < 2) {
      printUsage();
      return;
    }
    
    // Komputer to pierwszy parametr, port to drugi
    String host = args[0];
    int port;
    try {
      port = Integer.parseInt(args[1]);
    }
    catch (NumberFormatException e) {
      printUsage();
      return;
    }

    try {      
      // Otwarcie gniazda serwera
      Socket s = new Socket(host, port);

      // Rozpoczcie wtku wysyajcego dane z klawiatury do serwera
      new KeyboardInputManager(System.in, s).start();
      
      // Teraz wywietlenie wszystkich informacji otrzymanych 
      // z gniazda
      BufferedReader in = 
        new BufferedReader(new InputStreamReader(s.getInputStream()));
      String line;
      while ((line = in.readLine()) != null) {
        System.out.println(line);
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}

class KeyboardInputManager extends Thread {

  InputStream in;
  Socket s;

  public KeyboardInputManager(InputStream in, Socket s) {
    this.in = in;
    this.s = s;
    setPriority(MIN_PRIORITY);  // Gniazda odczytujce powinno posiada wyszy priorytet
                                // Niestety nie mona uy select() !                                    
    setDaemon(true);  // Pozwolenie na mier aplikacji, nawet jeeli ten wtek pracuje
  }

  public void run() {
    try {
      BufferedReader keyb = new BufferedReader(new InputStreamReader(in));
      PrintWriter server = new PrintWriter(s.getOutputStream());

      String line;
      System.out.println("Poczono... Prosz wprowadzi danie HTTP");
      System.out.println("------------------------------------------");
      while ((line = keyb.readLine()) != null) {
        server.print(line);
        server.print("\r\n");  // linia HTTP koczy si \r\n
        server.flush();
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
