import org.webmacro.*;
import org.webmacro.servlet.*;
import org.webmacro.util.*;
import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;

public class ToolServlet extends WMServlet {

  private Log log;
  private Tool[] tools;

  public void start() throws ServletException {    
    // Zaadowanie danych narzdzi do init w celu zachowania prostoty
    String toolsFile = getInitParameter("toolsFile"); // z web.xml
    if (toolsFile == null) {
      throw new ServletException(
        "Plik danych narzdzi musi by okrelony w parametrze inicjalizacji toolsFile");
    }
    log = new Log(getServletName(), "Dziennik bdw przykadu Tool");
    log.debug("adowanie narzdzi z " + toolsFile);
    try {
      tools = Tool.loadTools(toolsFile);
      if (tools.length == 0) {
        log.warning("Nie znaleziono adnych narzdzi w " + toolsFile);
      }
      else {
        log.info(tools.length + " narzdzia znaleziono w " + toolsFile);
      }
    }
    catch (Exception e) {
      log.error(e);
      throw new ServletException(e);
    }
  }

  // Tworzenie kontekstu dostarcza funkcji dostpnych z szablonw.
  public Template handle(WebContext context) throws HandlerException {    
    // Czsto przekazuje si danie odpowied i aplikacj, nawet jeeli nie s 
    // wykorzystane wszystkie obiekty, poniewa mog zosta wykorzystane pniej

    try {
      Template view = getTemplate(":ISO-8859-2:toolview.wm");
      String state = context.getRequest().getParameter("state");
      if (state == null) {
        state = (String)view.getParam("defaultState");
      }

      if (state == null) {
        context.put("tools", getTools()); 
      }
      else {
        context.put("tools", getTools(state));
      }
      return view;
    }
    catch (WebMacroException e) {
      log.exception(e);
      throw new HandlerException(e.getMessage());
    }
    catch (IOException e) {
      log.exception(e);
      throw new HandlerException(e.getMessage());
    }
  }

  public Tool[] getTools() {
    return tools;
  }

  public Tool[] getTools(String state) {
    List list = new LinkedList();
    for (int i = 0; i < tools.length; i++) {
      if (tools[i].getStateFlag().equalsIgnoreCase(state)) {
        list.add(tools[i]);
      }
    }
    return (Tool[]) list.toArray(new Tool[0]);
  }
}
