import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

import org.webmacro.*;
import org.webmacro.servlet.*;
import org.webmacro.engine.*;
import org.webmacro.broker.*;

// Rozszerzanie com.oreilly.servlet.CacheHttpServlet moe poprawi czas odpowiedzi

public class MacroView extends HttpServlet {

  WebMacro wm;  // gwny uchwyt WebMacro 

  public void init() throws ServletException {
    try {
      wm = new WM();
    }
    catch (InitException e) {
      throw new ServletException(e);
    }
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {    
    FastWriter out = new FastWriter(res.getOutputStream(),
                                    res.getCharacterEncoding());
    
    // Nazwa szablonu jest pobierana jako dodatkowy element cieki
    //   /servlet/MacroView/templ.wm
    // Lub jako cieka serwletu poprzez zasad *.wm
    //   /temp.wm

    String template = req.getPathInfo();
    if (template == null) {
      template = req.getServletPath();
      template = template.substring(1);  // odcicie pocztkowego "/"
    }
    
    // Jeeli cigle brak szablonu, problem
    if (template == null) {
      throw new ServletException(        
        "Nie okrelono adnego szablonu jako dodatkowy element cieki lub cieki serwletu");
    }

    try {
      Template tmpl = wm.getTemplate(":ISO-8859-2:" + template);
      WebContext context = wm.getWebContext(req, res); 
      tmpl.write(out, context);
    }
    catch (WebMacroException e) {
      throw new ServletException(e);
    }
    finally {
      out.flush();
    }
  }

  public void destroy() {
    super.destroy();
    if (wm != null) wm.destroy();
  }
}
