import java.io.*;
import java.sql.*;
import java.util.*;
import org.jdom.*;
import org.jdom.input.*;

public class Tool {  
  // Dane na temat tego rekordu narzedzie
  public int id;
  public String name;
  public String homeURL;
  public String comments;
  public String stateFlag;
  public Timestamp createdTime;
  public Timestamp modifiedTime;
  
  // Tea moe uzyska dostp jedynie do podstawowych waciwoci, 
  // potrzebne s wic specjalne metody dostpu
  public int getId() { return id; }
  public String getName() { return name; }
  public String getHomeURL() { return homeURL; }
  public String getComments() { return comments; }
  public String getStateFlag() { return stateFlag; }
  public Timestamp getCreatedTime() { return createdTime; }
  public Timestamp getModifiedTime() { return modifiedTime; }


  public int getCreatedAgeInDays() {
    return (int) ((System.currentTimeMillis() - createdTime.getTime()) /
            (24 * 60 * 60 * 1000));  // milisekundy w dniu
  }

  public int getModifiedAgeInDays() {
    return (int) ((System.currentTimeMillis() - modifiedTime.getTime()) /
            (24 * 60 * 60 * 1000));  // milisekundy w dniu
  }


  
  // Idealnie uyto by metod takich jak te, ale Tea pozwala jedynie na dostp
  // do waciwoci obiektu. Nie bd one widoczne.
  public boolean isNewWithin(int days) {
    return getCreatedAgeInDays() < days;
  }

  public boolean isUpdatedWithin(int days) {
    return getModifiedAgeInDays() < days;
  }


  public static Tool[] loadTools(String toolsFile) throws Exception {    
    // Odczytanie danych narzdzi z pliku XML zawierajcego elementy <tool>
    // Wykorzystanie interfejsu JDOM by uproci to dziaanie (http://jdom.org)

    List toolObjects = new LinkedList();

    SAXBuilder builder = new SAXBuilder();
    Document document = builder.build(new File(toolsFile));
    Element root = document.getRootElement();
    List toolElements = root.getChildren("tool");
    Iterator i = toolElements.iterator();
    while (i.hasNext()) {
      Element tool = (Element) i.next();
      Tool t = new Tool();
      t.id = tool.getAttribute("id").getIntValue();
      t.name = tool.getChild("name").getTextTrim();
      t.homeURL = tool.getChild("homeURL").getTextTrim();
      t.comments = tool.getChild("comments").getTextTrim();
      t.stateFlag = tool.getChild("stateFlag").getTextTrim();
      t.createdTime = Timestamp.valueOf(
                        tool.getChild("createdTime").getTextTrim());
      t.modifiedTime = Timestamp.valueOf(
                         tool.getChild("modifiedTime").getTextTrim());
      toolObjects.add(t);
    }

    return (Tool[]) toolObjects.toArray(new Tool[0]);
  }
}
