package com.oreilly.servlet;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public abstract class DaemonHttpServlet extends HttpServlet {

  protected int DEFAULT_PORT = 1313;  // nie jest static lub final
  private Thread daemonThread;

  public void init(ServletConfig config) throws ServletException {
    super.init(config);

    // rozpoczcie wtku demona
    try {
      daemonThread = new Daemon(this);
      daemonThread.start();
    }
    catch (Exception e) {
      log("Problem z uruchomieniem wtku demona: " +
          e.getClass().getName() + ": " + e.getMessage());
    }
  }

  // Zwraca port gniazda, na ktrym ten serwlet bdzie nasuchiwa
  // Serwlet moe okreli port na trzy sposoby  przy pomocy parametru  
  // inicjalizujcego socketPort, przez ustawienie zmiennej DEFAULT_PORT
  // przed wywoaniem super.init(), 
  // lub przez przedefiniowanie tej metody
  protected int getSocketPort() {
    try { return Integer.parseInt(getInitParameter("socketPort")); }
    catch (NumberFormatException e) { return DEFAULT_PORT; }
  }

  abstract public void handleClient(Socket client);

  public void destroy() {
    try {
      daemonThread.stop();
      daemonThread = null;
    }
    catch (Exception e) {
      log("Problem z zatrzymaniem wtku demona: " +
          e.getClass().getName() + ": " + e.getMessage());
    }
  }
}

// Praca ta wykonywana jest przez klas pomocnicz, 
// tak, aby podklasy DaemonHttpServlet 
// mogy bez problemw zdefiniowa swoj wasn metod run()

class Daemon extends Thread {

  private ServerSocket serverSocket;
  private DaemonHttpServlet servlet;

  public Daemon(DaemonHttpServlet servlet) {
    this.servlet = servlet;
  }

  public void run() {
    try {
      // Stworzenie gniazda serwera akceptujcego poczenia
      serverSocket = new ServerSocket(servlet.getSocketPort());
    }
    catch (Exception e) {
      servlet.log("Problem z rozpoczciem poczenia przez gniazdo: " +
                  e.getClass().getName() + ": " + e.getMessage());
      return;
    }

    try {
      while (true) {
        // Dla kadego przychodzcego poczenia, wywoana jest metoda handleClient()
        // serwletu
        // Prosz zauway, metoda ta jest blokujca. Na serwlet spada 
        // odpowiedzialno utworzenia wtku obsugujcego dugo trwajce poczenia.
         try {
          servlet.handleClient(serverSocket.accept());
        }
        catch (IOException ioe) {
          servlet.log("Problem z akceptacj poczenia dla gniazda klienta: " +
                      ioe.getClass().getName() + ": " + ioe.getMessage());
        }
      }
    }
    catch (ThreadDeath e) {
      // Kiedy wtek zostaje zabity, zamknicie gniazda serwera
      try {
        serverSocket.close();
      }
      catch (IOException ioe) {
        servlet.log("Problem z zamykaniem gniazda serwera: " +
                    ioe.getClass().getName() + ": " + ioe.getMessage());
      }
    }
  }
}
