import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;

import com.oreilly.servlet.HttpMessage;

public class HttpChatApplet extends Applet implements Runnable {

  TextArea text;
  Label label;
  TextField input;
  Thread thread;
  String user;

  public void init() {
    // Sprawdzenie, czy aplet zosta pobrany bezporednio z systemu plikw.
    // Jeeli tak, wyjanienie uytkownikowi, e musi on by pobrany z serwera w celu 
    // komunikacji z serwletami tego serwera

    URL codebase = getCodeBase();
    if (!"http".equals(codebase.getProtocol())) {
      System.out.println();      
      System.out.println("*** Ups! ***");
      System.out.println("Ten aplet musi by pobrany z serwera WWW.");
      System.out.println("Prosz sprbowa ponownie, tym razem adujc plik HTML");
      System.out.println("zawierajcy ten serwlet jako");
      System.out.println("\"http://serwer:port/plik.html\".");
      System.out.println();
      System.exit(1);  // Dziaa jedynie z appletviewer
                       // Przegldarki zgaszj bd i kontynuuj

    }

    // Pobranie nazwy tego uytkownika z parametru apletu ustawionego przez serwlet
    // Mona o to po prostu spyta uytkownika, ale jest to przedstawienie formy
    // komunikacji serwlet->aplet.

    user = getParameter("user");
    if (user == null) user = "anonymous";

    
    // konfiguracja interfejsu uytkownika...
    // Na grze due pole TextArea przedstawiajce ca rozmow.
    // Poniej oznaczony TextField przyjmujcy zdania tego uytkownika.

    text = new TextArea();    
    text.setEditable(false);
    label = new Label("Powiedz co: ");
    input = new TextField();
    input.setEditable(true);

    setLayout(new BorderLayout());
    Panel panel = new Panel();
    panel.setLayout(new BorderLayout());

    add("Center", text);
    add("South", panel);

    panel.add("West", label);
    panel.add("Center", input);
  }

  public void start() {
    thread = new Thread(this);
    thread.start();
  }

  String getNextMessage() {
    String nextMessage = null;
    while (nextMessage == null) {
      try {
        URL url = new URL(getCodeBase(), "/servlet/ChatServlet");
        HttpMessage msg = new HttpMessage(url);
        InputStream in = msg.sendGetMessage();
        DataInputStream data = new DataInputStream(
                               new BufferedInputStream(in));
        nextMessage = data.readLine();
      }
      catch (SocketException e) {        
        // Niemoliwe poczenie z komputerem, wypisz i czekaj 
        // przed ponown prb

        System.out.println("Poczenie z komputerem niemoliwe: "  + e.getMessage());
        try { Thread.sleep(5000); } catch (InterruptedException ignored) { }
      }
      catch (FileNotFoundException e) {
        // Servlet doesn't exist, report it and wait before trying again
        // Serwlet nie istnieje, wypisz i oczekuj
        System.out.println("Zasb nie odnaleziony: " + e.getMessage());
        try { Thread.sleep(5000); } catch (InterruptedException ignored) { }
      }
      catch (Exception e) {        
        // Inny problem, wypisz i oczekuj zanim sprbujesz ponownie
        System.out.println("Oglny wyjtek: " +
          e.getClass().getName() + ": " + e.getMessage());
        try { Thread.sleep(1000); } catch (InterruptedException ignored) { }
      }
    }
    return nextMessage + "\n";
  }

  public void run() {
    while (true) {
      text.appendText(getNextMessage());
    }
  }

  public void stop() {
    thread.stop();
    thread = null;
  }

  void broadcastMessage(String message) {
    message = user + ": " + message;  // Na pocztku dodanie nazwy uytkownika
    try {
      URL url = new URL(getCodeBase(), "/servlet/ChatServlet");
      HttpMessage msg = new HttpMessage(url);
      Properties props = new Properties();
      props.put("message", message);
      msg.sendPostMessage(props);
    }
    catch (SocketException e) {
      // Can't connect to host, report it and abandon the broadcast
      // Niemoliwe poczenie z komputerem, wypisz i zaprzesta 
      // nadawania

      System.out.println("Niemoliwe poczenie z komputerem: " + e.getMessage());
    }
    catch (FileNotFoundException e) {
      // Servlet doesn't exist, report it and abandon the broadcast
      // Serwlet nie istnieje, wypisz i zaprzesta nadawania
      System.out.println("Zasb nie odnaleziony: " + e.getMessage());
    }
    catch (Exception e) {
      // Some other problem, report it and abandon the broadcast
      // Inny problem, wypisz i zaprzesta nadawania
      System.out.println("Oglny wyjtek: " +
        e.getClass().getName() + ": " + e.getMessage());
    }
  }

  public boolean handleEvent(Event event) {
    switch (event.id) {
      case Event.ACTION_EVENT:
        if (event.target == input) {
          broadcastMessage(input.getText());
          input.setText("");
          return true;
        }
    }
    return false;
  }
}
