import java.sql.*;
import java.util.*;

public class ConnectionPool {
   private Hashtable connections = new Hashtable();
   private Properties props;

   public ConnectionPool(Properties props, int initialConnections)
            throws SQLException, ClassNotFoundException {
      this.props = props;
      initializePool(props, initialConnections);
   }

   public ConnectionPool(String driverClassName, String dbURL,
            String user, String password,
          int initialConnections)
         throws SQLException, ClassNotFoundException {
      props = new Properties();
      props.put("connection.driver", driverClassName);
      props.put("connection.url", dbURL);
      props.put("user", user);
      props.put("password", password);
      initializePool(props, initialConnections);
   }
   
   public Connection getConnection() throws SQLException {
      Connection con = null;

       Enumeration cons = connections.keys();

      synchronized (connections) {
         while (cons.hasMoreElements()) {
         con = (Connection)cons.nextElement();

            Boolean b = (Boolean)connections.get(con);
            if (b == Boolean.FALSE) {
              // Znalelimy nieuywane poczenie.
              // Naley sprawdzi jego integralno szybkim 
              // wywoaniem setAutoCommit(true).
              // Do uytku komercyjnego powinno si wykona
              //wicej testw, takich jak wykonanie prostego zapytania
          try {
             con.setAutoCommit(true);
          }
             catch(SQLException e) {
             // Jeli jest problem z poczeniem naley je zamieni na nowe
             connections.remove(con);
             con = getNewConnection();
              }
              //Zaktualizuj Hashtable
              connections.put(con, Boolean.TRUE);
              //Zwr poczenie
           return con;
           }
        }

    // Jeli si tu dostalimy, to oznacza, e nie ma wolnych pocze. Naley 
    // utworzy nowe poczenie.
     con = getNewConnection();
     connections.put(con, Boolean.FALSE);
     return con;
    }
  }
  
   public void returnConnection(Connection returned) {
      if (connections.containsKey(returned)) {
         connections.put(returned, Boolean.FALSE);
      }
   }

   private void initializePool (Properties props, int initialConnections)
           throws SQLException, ClassNotFoundException {
            //adujemy sterownik
     Class.forName(props.getProperty("connection.driver"));

      // Umieszczamy nasz pul pocze w Hashtable
      // Warto FALSE wskazuje na nieuywane poczenie
      for (int i = 0; i < initialConnections; i++) {
      Connection con = getNewConnection();
      connections.put(con, Boolean.FALSE);
      }
   }

   private Connection getNewConnection() throws SQLException {
      return DriverManager.getConnection(
      props.getProperty("connection.url"),props);
   }
}
