import java.io.*;
import java.util.*;
import javax.servlet.* ;
import javax.servlet.http.*;

public class SessionBindings extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                     throws ServletException, IOException {
      res.setContentType("text/plain; charset=ISO-8859-2");
      PrintWriter out = res.getWriter();

      // Pobierz aktualny obiekt sesji, w razie potrzeby utwrz go
      HttpSession session = req.getSession();

      // Dodaj CustomBindingListener
      session.setAttribute("bindings.listener",
               new CustomBindingListener(getServletContext()));

      out.println("Ta strona jest celowo pozostawiona pust");
   }
}

class CustomBindingListener implements HttpSessionBindingListener {

   // Zapisz ServletContext dla uytku jego metody log () 
   ServletContext context;

   public CustomBindingListener(ServletContext context) {
     this.context = context;
}

public void valueBound(HttpSessionBindingEvent event) {
   context.log("[" + new Date() + "] ZWIZANO " + event.getName() +
         " z " + event.getSession().getId());
}

public void valueUnbound(HttpSessionBindingEvent event) {
   context.log("[" + new Date() + "] ROZWIZANO " + event.getName () +
            " z " + event. getSession().getId() );
   }
}
