import java.io.*;
import java.net.*;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;

public class KeyedServerUnlock extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    res.setContentType("text/plain; charset=ISO-8859-2") ;
    PrintWriter out = res.getWriter();

      // Pobierz nazwe hosta i jego port
      String host = req.getParameter ("host");
      String port = req.getParameter ("port");

      // Jeeli nie ma zdefiniowanej nazy hosta / uyj biecego komputera                  
      if (host == null) {
         host = req.getServerName();
      }

      // Konwertuj port na liczb rzeczywist, jeeli nie ma adnego  
      //uyj portu biecego
      int numericPort;
      try {
         numericPort = Integer.parseInt(port);
      }
      catch (NumberFormatException e) {
         numericPort = req.getServerPort() ;
      }

      // Wygeneruj i wypisz klucz
      // Jakikolwiek wyjtek KeyGenerationException jest wyapywany i wywietlany
      try {
         long key = generateKey(host, numericPort) ;
         out.println (host + ": "+ numericPort + " posiada klucz " + key);
      }
      catch (KeyGenerationException e) {
      out.println("Nie dao si wygenerowa klucza: "+e.getMessage());
      }
    }

    // Metoda ta zawiera algorytm uywany do dopasowania klucza z
    // serwerem i jego portem. Niniejsza przykadowa
    // implementacja jest dalece niedoskonaa i nie powinna by uywana 
    // przez strony komercyjne.

    // Zgasza wyjtek KeyGenerationException poniewa wszystko 
    // bardziej sprecyzowane byoby zwizane z wybranym algorytmem.

private long generateKey(String host,int port) throws 
          KeyGenerationException {

   // Klucz musi by liczb 64-bitow rwn logicznej negacji not (~)
   // 32-bitowego adresu IP poczonego przez 32-bitowy numer portu.

   byte hostIP[];
   try {
      hostIP = InetAddress.getByName(host).getAddress () ;

   }
   catch (UnknownHostException e) {
      throw new KeyGenerationException(e.getMessage());
   }

   // Pobierz 32 bitowy adres IP
   long servercode = 0;
   for (int i = 0; i < 4; i++) {
      servercode <<= 8;
      servercode |= hostIP[i];
   }


   // Pocz 32-bitowy numer portu
   servercode <<= 32;
   servercode |= port;

   // Klucz jest logicznym przeczeniem
   return ~servercode;

   }
}

class KeyGenerationException extends Exception {

   public KeyGenerationException() {
      super() ;
}

public KeyGenerationException(String msg) {
   super (msg) ;
   }
}
