import com.go.teaservlet.*;
import com.go.trove.log.*;
import java.sql.Timestamp;
import java.util.*;
import javax.servlet.*;

public class ToolApp implements Application {

  private Log log;
  private Tool[] tools;

  public void init(ApplicationConfig config) throws ServletException {    
    // Dziennik zdarze wydarze specyficznych dla tej aplikacji
    log = config.getLog();
    
    // Pobranie danych o narzdziach w metodzie init dla zachowania prostoty
    String toolsFile = config.getInitParameter("toolsFile");
    if (toolsFile == null) {
      throw new ServletException(        
        "Plik danych o narzdziach musi zosta okrelony jako parametr inicjalizacji toolsFile"); 
    }
    log.debug("Pobieranie narzdzi z " + toolsFile);
    try {
      tools = Tool.loadTools(toolsFile);
      if (tools.length == 0) {
        log.warn("Nie znaleziono narzdzi w " + toolsFile);
      }
    }
    catch (Exception e) {
      log.error(e);
      throw new ServletException(e);
    }
  }

  public Object createContext(ApplicationRequest request,
                              ApplicationResponse response) {
    return new ToolContext(request, response, this);
  }

  public Class getContextType() {
    return ToolContext.class;
  }

  public void destroy() {
  }

  public Tool[] getTools() {    
    // Zazwyczaj "application" utrzymywaaby lub miaaby dostp do wczeniej utworzonej 
    // bazy danych. Tutaj dla zachowania prostoty zastosowano plik XML
    return tools;
  }

  public Tool[] getTools(String state) {    
    // Zwracane tylko narzdzia o okrelonym stanie
    // (wysane, yje, odrzucone, lub martwe)
    List list = new LinkedList();
    for (int i = 0; i < tools.length; i++) {
      if (tools[i].getStateFlag().equalsIgnoreCase(state)) {
        list.add(tools[i]);
      }
    }
    return (Tool[]) list.toArray(new Tool[0]);
  }
}
