import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.ServletUtils;

public class UnsafeViewResource extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
      // Zastosuj ServletOutputStream poniewa moemy przekaza informacj binarn
      ServletOutputStream out = res.getOutputStream();
      res. setContentType("text/plain; charset=ISO-8859-2");

      // Pobierz zasb do przegldania
      String file = req.getPathInfo();
      if (file == null) {
         out.println("Informacja dodatkowej cieki wynosia null;"
                          + " powinna by zasobem do przegldania");
         return;
      }

    // Konwertuj zasb na URL
    // UWAGA:Przyznanie dostpu do plikw pod WEB-INF oraz rda .jsp
    URL url = getServletContext().getResource(file);
    if (url == null) { // niektre serwery odel null w przypadku nieznalezienia
    out.println("Zasb " + file + " nie odnaleziony");
    return;
    }

    // Pocz z zasobem
    URLConnection con = null;
    try { 
      con = url.openConnection();
      con.connect();
}
    catch (IOException e) {
      out.println("Zasb "+file+" nie moe zosta odczytany: "+e.getMessage());
    return;
}

    // Pobierz i ustal typ zasobu
    String contentType = con.getContentType();
    res. setContentType (contentType) ;

    // Zwr zasb 
    // UWAGA: Zwraca pliki spod WEB-INF i rda .jsp
    try {
       ServletUtils.returnURL (url, out) ;
    }
    catch (IOException e) {
      res. sendError (res.SC_INTERNAL_SERVER_ERROR,
                "Problem przy przesyaniu zasobu: " + e.getMessage());
   }
  }
}
