describe("Model", function(){
  var Asset;
  
  beforeEach(function(){
    Asset = Model.setup();
    Asset.attributes = ["name"];
  });
  
  it("może tworzyć rekordy", function(){
    var asset = Asset.create({name: "test.pdf"});
    expect(Asset.first()).toEqual(asset);
  });

  it("może zmieniać rekordy", function(){
    var asset = Asset.create({name: "test.pdf"});

    expect(Asset.first().name).toEqual("test.pdf");

    asset.name = "wem.pdf";
    asset.save();
    
    expect(Asset.first().name).toEqual("wem.pdf");
  });
  
  it("może usuwać rekordy", function(){
    var asset = Asset.create({name: "test.pdf"});

    expect(Asset.first()).toEqual(asset);
    
    asset.destroy();
    
    expect(Asset.first()).toBeFalsy();
  });
});