module("Test modelu", {
  setup: function(){
    this.Asset = Model.setup();
  }
});

test("load()", function(){
  var a = this.Asset.init();
  a.load({
    local: true, 
    name: "test.pdf"
  });
  
  ok(a.local, "Load ustawia właściwości");
  equals(a.name, "test.pdf", "load() ustawia właściwości (2)");
  
  var b = this.Asset.init({
    name: "test2.pdf"
  });
  
  equals(b.name, "test2.pdf", "Wywołanie load() w trakcie tworzenia instancji");
});

test("attributes()", function(){
  this.Asset.attributes = ["name"];

  var a = this.Asset.init();
  a.name = "test.pdf";
  a.id   = 1;

  same(a.attributes(), {
    name: "test.pdf",
    id: 1
  });
});

test("find()", function(){
  var a = this.Asset.create();
  
  equals(this.Asset.find(a.id).id, a.id, "Zwraca zapisane zasoby");
  
  raises(function(){
    this.Asset.find("non-existant-id");
  }, "Rzucane, gdy zasób Asset nie istnieje");
});