jQuery(function($){

window.Sidebar = Spine.Controller.create({
  // Utworzenie zmiennych instancji:
  //  this.items //=> <ul></ul>
  //  this.input //=> <input />
  elements: {
    ".items": "items",
    "input":  "input"
  },
  
  // Dołączenie delegacji zdarzeń
  events: {
    "click button": "create",
    "keyup input":  "filter",
    "click input":  "filter"
  },
  
  // Zapewnienie, że funkcje te zostaną wywołane w bieżącym
  // zasięgu, ponieważ są używane w wywołaniach zwrotnych zdarzeń
  proxied: ["render"],
  
  // Wygenerowanie szablonu
  template: function(items){
    return($("#contactsTemplate").tmpl(items));
  },
  
  init: function(){
    this.list = Spine.List.init({
      el: this.items,
      template: this.template
    });
    
    this.list.bind("change", this.proxy(function(item){
      this.App.trigger("show:contact", item);
    }));
    this.App.bind("show:contact edit:contact", this.list.change);
    
    // Ponowne wygenerowanie po wypełnieniu lub zmianie danych kontaktowych
    Contact.bind("refresh change", this.render);
  },

  filter: function(){
    this.query = this.input.val();
    this.render();
  },
  
  render: function(){
    // Filtrowanie pozycji na podstawie zapytania
    var items = Contact.filter(this.query);
    // Filtrowanie na podstawie imienia
    items = items.sort(Contact.nameSort);
    this.list.render(items);
  },
    
  // Wywoływane, gdy kliknięty zostanie przycisk 'Create'
  create: function(){
    var item = Contact.create();
    this.App.trigger("edit:contact", item);
  }
});
  
});