﻿// default.js
// Poniższa dokumentacja zawiera wprowadzenie do szablonu Split:
// http://go.microsoft.com/fwlink/?LinkID=232447
(function () {
  "use strict";

  var app = WinJS.Application;
  var activation = Windows.ApplicationModel.Activation;
  var nav = WinJS.Navigation;
  WinJS.strictProcessing();

  app.addEventListener("activated", function (args) {
    if (args.detail.kind === activation.ActivationKind.launch) {
      if (args.detail.previousExecutionState !== activation.ApplicationExecutionState.terminated) {
        // Do zrobienia: Aplikacja została dopiero uruchomiona.
        // Zainicjuj ją tutaj.
      } else {
        // Do zrobienia: Aplikacja zostałą wznowiona po wstrzymaniu.
        // Odtwórz tutaj stan aplikacji.
      }

      if (app.sessionState.history) {
        nav.history = app.sessionState.history;
      }
      args.setPromise(WinJS.UI.processAll().then(function () {
        if (nav.location) {
          nav.history.current.initialPlaceholder = true;
          return nav.navigate(nav.location, nav.state);
        } else {
          return nav.navigate(Application.navigator.home);
        }
      }));
    }
  });

  app.oncheckpoint = function (args) {
    // Do zrobienia: Aplikacja będzie wstrzymana. Tutaj zapisz stan, który
    // musi być przetrwać wstrzymanie. Jeżeli jakaś operacja asynchroniczna
    // musi być zakończona przed wstrzymaniem aplikacji, wywołaj args.setPromise().
    app.sessionState.history = nav.history;
  };

  app.onsettings = function (e) {
    e.detail.applicationcommands = {
      feedsFlyout: { title: "Kanały", href: "/settings/feeds/feeds.html" },
      aboutFlyout: { title: "O aplikacji", href: "/settings/about/about.html" },
    };

    WinJS.UI.SettingsFlyout.populateSettings(e);
  };


  /* Udostępnij dane */
  var dataManager = Windows.ApplicationModel.DataTransfer.DataTransferManager;

  var dataTransfer = dataManager.getForCurrentView();
  dataTransfer.addEventListener("datarequested", function (args) {

    var request = args.request;

    var splitPageUri = "/pages/split/split.html";
    // Sprawdź, czy bieżącą stroną jest strona podziału
    if (nav.location == splitPageUri) {

      var page = WinJS.UI.Pages.get("/pages/split/split.html");

      var currentPage = WinJS.Navigation.history.current;

      // Prześlij tylko wtedy, gdy wybrany jest bieżący element
      if (currentPage.state.selectedItem) { 

        // Określ dane, które chcesz udostępnić
        var item = currentPage.state.selectedItem.data;
        request.data.properties.title = item.title;
        request.data.properties.description = item.description;
        request.data.setText(item.title);
        request.data.setUri(item.originalUri);
        request.data.setHtmlFormat(item.content);
        request.data.setBitmap(Data.appIconStreamReference);

      } else {
          request.failWithDisplayText("Musisz wyświetlić treść, aby ją udostępnić.");
      }
    } else { 
        request.failWithDisplayText("Musisz wyświetlić treść, aby ją udostępnić.");
    }
  });

  app.start();
})();
