﻿// Poniższa dokumentacja zawiera wprowadzenie do szablonu Navigation:
// http://go.microsoft.com/fwlink/?LinkId=232506
(function () {
    "use strict";

    var app = WinJS.Application;
    var activation = Windows.ApplicationModel.Activation;
    var nav = WinJS.Navigation;
    WinJS.strictProcessing();

    app.addEventListener("activated", function (args) {
        if (args.detail.kind === activation.ActivationKind.launch) {
            if (args.detail.previousExecutionState !== activation.ApplicationExecutionState.terminated) {
              // Do zrobienia: Aplikacja została dopiero uruchomiona.
              // Zainicjuj ją tutaj.
            } else {
              // Do zrobienia: Aplikacja zostałą wznowiona po wstrzymaniu.
              // Odtwórz tutaj stan aplikacji.
            }

            if (app.sessionState.history) {
                nav.history = app.sessionState.history;
            }
            args.setPromise(WinJS.UI.processAll().then(function () {
                if (nav.location) {
                    nav.history.current.initialPlaceholder = true;
                    return nav.navigate(nav.location, nav.state);
                } else {
                    return nav.navigate(Application.navigator.home);
                }
            }));
        }
    });

    app.oncheckpoint = function (args) {
        // Do zrobienia: Aplikacja będzie wstrzymana. Tutaj zapisz stan, który
        // musi być przetrwać wstrzymanie. Jeżeli jakaś operacja asynchroniczna
        // musi być zakończona przed wstrzymaniem aplikacji, wywołaj args.setPromise().
        app.sessionState.history = nav.history;
    };

    app.start();
})();
