﻿// backgroundtask.js
(function () {
  "use strict";

  // zaimportuj inne skrypty
  importScripts("//Microsoft.WinJS.1.0/js/base.js", "/js/backgrounddata.js");

  var ui = Windows.UI.WebUI;

  // pobierz bieżącą instancję zadania
  var task = ui.WebUIBackgroundTaskInstance.current;

  // Obsłuż elegancko przerwanie wykonywania, jeżeli to możliwe
  var hasCancelled = false; 

  // obsłuż przerwanie wykonywania
  task.addEventListener("cancelled", function (sender, reason) {
    hasCancelled = true;
  });

  // zaktualizuj numer na znaczku
  function updateBadge(number) {

    var notifications = Windows.UI.Notifications;

    // Pobierz znaczek pokazujący ilość wpisów w RSS Reader
    var type = notifications.BadgeTemplateType.badgeNumber;

    // Pobierz szablon XML
    var xml = notifications.BadgeUpdateManager.getTemplateContent(type);

    // Pobierz element znaczka, aby umieścić na nim numer
    var badgeElement = xml.getElementsByTagName("badge")[0];
    badgeElement.setAttribute("value", number.toString());

    // Utwórz powiadomienie
    var badge = new notifications.BadgeNotification(xml);

    // Wyślij powiadomienie, aby zaktualizował się znaczek
    var updater = notifications.BadgeUpdateManager.createBadgeUpdaterForApplication();
    updater.update(badge);
  }


  // Uruchom i pobierz ilość danych
  BackgroundData.processAll(function (totalItems) {

    // zaktualizuj znaczek
    updateBadge(totalItems);

    // oznacz zadanie jako ukończone
    close();
  });

})();