﻿// Poniższa dokumentacja zawiera wprowadzenie do szablonu Page Control:
// http://go.microsoft.com/fwlink/?LinkId=232511
(function () {
  "use strict";

  var contacts = Windows.ApplicationModel.Contacts;

  WinJS.UI.Pages.define("/pages/contacts/contacts.html", {
    ready: function (element, options) {
      // trzymaj referencję do obiektu ContactPickerUI z systemu operacyjnego
      this.picker = options.contactPickerUI;

      // jeżeli użytkownik usunie kontakt z selektora, powiadom nas
      this.picker.addEventListener("contactremoved", oncontactremoved.bind(this));

      // obsłuż wybór kontaktu
      this.contactList = element.querySelector("#contactList").winControl;
      this.contactList.addEventListener("iteminvoked", oncontactselected.bind(this));
    },

    unload: function () {
      // selektor żyje po zamknięciu aplikacji, więc wyczyść dane
      picker.removeEventListener("contactremoved", oncontactremoved.bind(this));
    },

  });

  function oncontactremoved(args) {
    // identyfikator usuniętego elementu przekazany do funkcji
    var id = parseInt(args.id);
    var contactList = this.contactList;

    // wyszukaj element z tym identyfikatorem
    Data.sampleContacts.forEach(function (item) {
      if (item.id == id) {
        contactList.selection.remove(Data.sampleContacts.indexOf(item));
        return false; // wyjście z pętli
      }
    });
  }

  function oncontactselected(args) {
    var selectedIndex = args.detail.itemIndex;
    if (selectedIndex > -1) {
      var item = Data.sampleContacts.getAt(selectedIndex);
      if (this.picker.containsContact(item.id)) {
        this.picker.removeContact(item.id);
      }
      else {
        addContact(this.picker, item);
      }
    }
  }

  function addContact(picker, item) {
    // utwórz element kontaktu
    var contact = new Windows.ApplicationModel.Contacts.Contact();

    // dodaj właściwości
    contact.name = item.name;
    contact.fields.append(new contacts.ContactField(item.email,
      contacts.ContactFieldType.email,
      contacts.ContactFieldCategory.work));
    contact.fields.append(new contacts.ContactField(item.phone,
      contacts.ContactFieldType.phoneNumber,
      contacts.ContactFieldCategory.work));

    // dodaj kontakt
    var result = picker.addContact(item.id, contact);

    // sprawdź błędy
    switch (result) {
      case contacts.Provider.AddContactResult.added:
      case contacts.Provider.AddContactResult.alreadyAdded:
        break; // OK

      case contacts.Provider.AddContactResult.unavailable:
      default:
        break; // TODO: nieudane dodanie kontaktu — wyświetl błąd
    }
  }
})();
