﻿// Poniższa dokumentacja zawiera wprowadzenie do szablonu Navigation:
// http://go.microsoft.com/fwlink/?LinkId=232506
(function () {
  "use strict";

  WinJS.Binding.optimizeBindingReferences = true;

  var app = WinJS.Application;
  var activation = Windows.ApplicationModel.Activation;
  var nav = WinJS.Navigation;

  app.addEventListener("activated", function (args) {
    if (args.detail.kind === activation.ActivationKind.launch) {
      if (args.detail.previousExecutionState !== activation.ApplicationExecutionState.terminated) {
        // Do zrobienia: Aplikacja została dopiero uruchomiona.
        // Zainicjuj ją tutaj.
      } else {
        // Do zrobienia: Aplikacja zostałą wznowiona po wstrzymaniu.
        // Odtwórz tutaj stan aplikacji.
      }
    }

    var downloading = false;
    var netinfo = Windows.Networking.Connectivity.NetworkInformation;
    if (netinfo.getInternetConnectionProfile() != null) { /* połączony */
      downloadFeeds();
    }

    //netinfo.onnetworkstatuschanged = function () {
    //  if (netinfo.getInternetConnectionProfile() != null) { downloadFeeds(); }
    //  else { cancelFeedDownload(); }
    //};

    function downloadFeeds() { if (downloading) { return; } downloading = true; }
    function downloadFavoriteFeeds() { if (downloading) { return; } downloading = true; }
    function cancelFeedDownload() { if (!downloading) { return; } downloading = false; }

    function getEnumName(enumeration, value) {
      for (var name in enumeration) {
        if (enumeration[name] == value) { return name; }
      }
      return undefined;
    }

    // wyświetlenie niektórych danych o połączeniu sieciowym
    var netcost = Windows.Networking.Connectivity.NetworkCostType;
    var cost = netinfo.getInternetConnectionProfile().getConnectionCost();
    var networkCostTypeName = getEnumName(netcost, cost.networkCostType);

    output.innerHTML += "<p>networkCostType= " + networkCostTypeName + "</p>";
    output.innerHTML += "<p>roaming= " + cost.roaming + "</p>";
    output.innerHTML += "<p>overDataLimit= " + cost.overDataLimit + "</p>";
    output.innerHTML += "<p>approachingDataLimit= " + cost.approachingDataLimit + "</p>";
    output.innerHTML += "<p>costType= " + getCostType(cost) + "</p>";
  });

  var netinfo = Windows.Networking.Connectivity.NetworkInformation;
  var netcost = Windows.Networking.Connectivity.NetworkCostType;

  // sprawdź koszty połączenia, aby podjąć decyzję
  function getCostType(cost) {
    if (cost.roaming) { return "wysokie"; }

    switch (cost.networkCostType) {
      case netcost.variable:
        return "niskie";

      case netcost.fixed:
        if (cost.approachingDataLimit || cost.overDataLimit) { return "high"; }
        else { return "niskie"; }

      case netcost.unrestricted:
      case netcost.unknown:
        return "bezpłatne";
    }
  }

  function checkConnection() {
    var profile = netinfo.getInternetConnectionProfile();
    if (profile != null) {
      // jeżeli jesteśmy połączeni, sprawdź koszty
      switch (getCostType(profile.getConnectionCost())) {
        case "high": cancelFeedDownload(); break;
        case "low": downloadFavoriteFeeds(); break;
        case "free": downloadFeeds(); break;
      }
    }
    else {
      // jeżeli nie jesteśmy już połączeni, przerwij pobieranie
      cancelFeedDownload();
    }
  }

  netinfo.onnetworkstatuschanged = checkConnection;

  app.oncheckpoint = function (args) {
    // Do zrobienia: Aplikacja będzie wstrzymana. Tutaj zapisz stan, który
    // musi być przetrwać wstrzymanie. Jeżeli jakaś operacja asynchroniczna
    // musi być zakończona przed wstrzymaniem aplikacji, wywołaj args.setPromise().
    app.sessionState.history = nav.history;
  };

  app.start();
})();
