﻿(function () {
    "use strict";
		
    var images = new WinJS.Binding.List([
			{ url: "images/BostonCityFlow.jpg", caption: "Niesamowite zdjęcie Bostonu" },
			{ url: "images/Chrysanthemum.jpg", caption: "Ulubiony kwiat Chrisa" },
			{ url: "images/Penguins.jpg", caption: "Win8 jest na językach pingwiniej społeczności" },
			{ url: "images/PensiveParakeet.jpg", caption: "Szachowe mistrzostwa Bobbiego Fischera z Avian" },
			{ url: "images/CostaRicanFrog.jpg", caption: "Żaba, którą spotkałem kiedyś w Costa Rica" },
			{ url: "images/Jellyfish.jpg", caption: "Czyż meduzy nie są super?" },
			{ url: "images/Hydrangeas.jpg", caption: "Ulubiony kwiat Brandona" },
			{ url: "images/Koala.jpg", caption: "Cześć!" }
    ]);

    WinJS.Namespace.define('Photos', {
    	imageList: images
    });

    var app = WinJS.Application;

    window.addEventListener('resize', function () {
        setListViewLayout(Windows.UI.ViewManagement.ApplicationView.value);
    });

    app.onactivated = function (eventObject) {
    	WinJS.UI.processAll();
    	setListViewLayout(Windows.UI.ViewManagement.ApplicationView.value);
    };

    function setListViewLayout(viewState) {
    	var listView = document.querySelector('#imgContainer').winControl;
    	var stateEnum = Windows.UI.ViewManagement.ApplicationViewState;

    	if ((viewState === stateEnum.fullScreenPortrait) || (viewState === stateEnum.snapped)) {
    		listView.layout = new WinJS.UI.ListLayout();
    	} else {
    		listView.layout = new WinJS.UI.GridLayout();
    	}
    }

    app.start();
})();
