﻿(function() {
	var topics = {},
      subUid = -1;
	
	WinJS.Namespace.define("Observer", {
	    // Opublikuj zdarzenia rozgłoszeniowe
	    // z określonym tematem i argumentami,
        // takimi jak przekazywane dane
		publish: function( topic, args ) {

			if ( !topics[topic] ) {
				return false;
			}

			var subscribers = topics[topic],
            len = subscribers ? subscribers.length : 0;

			while (len--) {
				subscribers[len].func( topic, args );
			}

			return this;
		},
	    // Subskrybuj żądane zdarzenia
	    // o określonym temacie
	    // i funkcją zwrotną wywoływaną
        // gdy pojawi się obserwowane zdarzenie
		subscribe: function( topic, func ) {

			if (!topics[topic]) {
				topics[topic] = [];
			}

			var token = ( ++subUid ).toString();
			topics[topic].push({
				token: token,
				func: func
			});
			return token;
		},
	    // Anuluj subskrypcję określonego
	    // tematu w oparciu o odwołanie
        // do subskrypcji
		unsubscribe: function( token ) {
			for ( var m in topics ) {
				if ( topics[m] ) {
					for ( var i = 0, j = topics[m].length; i < j; i++ ) {
						if ( topics[m][i].token === token) {
							topics[m].splice( i, 1 );
							return token;
						}
					}
				}
			}
			return this;
		}
	});
})();