﻿// backgroundtask.js
(function () {
  "use strict";

  // zaimportuj inne skrypty
  importScripts("//Microsoft.WinJS.1.0/js/base.js", "/js/backgrounddata.js");

  var ui = Windows.UI.WebUI;

  // pobierz bieżącą instancję zadania
  var task = ui.WebUIBackgroundTaskInstance.current;

  // Obsłuż elegancko przerwanie wykonywania, jeżeli to możliwe
  var hasCancelled = false;

  // obsłuż przerwanie wykonywania
  task.addEventListener("cancelled", function (sender, reason) {
    hasCancelled = true;
  });

  function showNotification(numberFound) {
    var notifications = Windows.UI.Notifications;

    var notifier = notifications.ToastNotificationManager.createToastNotifier();

    // upewnij się, że można pokazać powiadomienia
    if (notifier.setting == notifications.NotificationSetting.enabled) {

      // określ rodzaj powiadomienia
      var type = notifications.ToastTemplateType.toastImageAndText01;

      // pobierz szablon XML do modyfikacji
      var xml = notifications.ToastNotificationManager.getTemplateContent(type);

      // zaktualizuj obraz
      var img = xml.getElementsByTagName("image")[0];
      img.setAttribute("src", "ms-appx:///images/logo.png");

      // zaktualizuj tekst
      var txt = xml.getElementsByTagName("text")[0];
      txt.appendChild(xml.createTextNode("Masz " + numberFound + " nowych wiadomości"));

      // opcjonalnie ustaw czas trwania
      //xml.setAttribute("duration", "long");

      // pobierz element powiadomienia
      var node = xml.selectSingleNode("/toast");

      // utwórz element dźwiękowy
      //var sound = xml.createElement("audio");

      // ustaw niestandardowy dźwięk
      //sound.setAttribute("src", "ms-winsoundevent:Notification.Reminder");

      // albo ustaw cieche powiadomienie
      //sound.setAttribute("silent", "true");

      // dodaj je do powiadomienia
      //node.appendChild(sound);

      // utwórz informację wysyłaną w celu aktywacji po kliknięciu / stuknięciu
      ////node.setAttribute("launch", "App Specific String passed down...can be JSON");
      node.setAttribute("launch", '{ "reason": "Toast", "url": "/foo/bar" }');

      // utwórz obiekt powiadomienia
      var toast = new notifications.ToastNotification(xml);

      // pokaż powiadomienie użytkownikowi
      notifier.show(toast);

      // utwórz zaplanowane powiadomienie
      var delivery = new Date().getTime() + (1000 * 60 * 60); // od teraz za godzinę
     // var delivery = new Date().getTime();
      var scheduledToast = new notifications.ScheduledToastNotification(xml, new Date(delivery));

      // zaplanuj powiadomienie
      notifier.addToSchedule(scheduledToast);
    }
  }

  // aktualizuj numer znaczka
  function updateBadge(number) {

    var notifications = Windows.UI.Notifications;

    // Pobierz znaczek pokazujący ilość wpisów w RSS Reader
    var type = notifications.BadgeTemplateType.badgeNumber;

    // Pobierz szablon XML
    var xml = notifications.BadgeUpdateManager.getTemplateContent(type);

    // Pobierz element znaczka, aby umieścić na nim numer
    var badgeElement = xml.getElementsByTagName("badge")[0];
    badgeElement.setAttribute("value", number.toString());

    // Utwórz powiadomienie
    var badge = new notifications.BadgeNotification(xml);

    // Wyślij powiadomienie, aby zaktualizował się znaczek
    var updater = notifications.BadgeUpdateManager.createBadgeUpdaterForApplication();
    updater.update(badge);
  }


  // Uruchom i pobierz ilość danych
  BackgroundData.processAll(function (totalItems) {

    // zaktualizuj znaczek
    showNotification(totalItems);

    // oznacz zadanie jako ukończone
    close();
  });

})();