﻿// split.js
(function () {
"use strict";

var appViewState = Windows.UI.ViewManagement.ApplicationViewState;
var binding = WinJS.Binding;
var nav = WinJS.Navigation;
var ui = WinJS.UI;
var utils = WinJS.Utilities;

WinJS.UI.Pages.define("/pages/split/split.html", {

  /// <field type="WinJS.Binding.List" />
  items: null,
  /// <field type="Object" />
  group: null,
  itemSelectionIndex: -1,

  // Ta funkcja sprawdza, czy lista i szczegóły kolumn mają
  // być pokazane na osobnych stronach a nie na sąsiednich.
  isSingleColumn: function () {
    var viewState = Windows.UI.ViewManagement.ApplicationView.value;
    return (viewState === appViewState.snapped || viewState === appViewState.fullScreenPortrait);
  },

  // Ta funkcja jest wywoływana, gdy użytkownik otworzy tę stronę.
  // Umieszcza dane aplikacyjne w elementach strony.
  ready: function (element, options) {
    var listView = element.querySelector(".itemlist").winControl;

    // Zapamiętaj informację o grupie i wyborze,
    // które będą pokazane na stronie
    this.group = (options && options.groupKey) ? Data.resolveGroupReference(options.groupKey) : Data.groups.getAt(0);
    this.items = Data.getItemsFromGroup(this.group);
    this.itemSelectionIndex = (options && "selectedIndex" in options) ? options.selectedIndex : -1;

    element.querySelector("header[role=banner] .pagetitle").textContent = this.group.title;

    // Skonfiguruj obiekt ListView.
    listView.itemDataSource = this.items.dataSource;
    listView.itemTemplate = element.querySelector(".itemtemplate");
    listView.onselectionchanged = this.selectionChanged.bind(this);
    listView.layout = new ui.ListLayout();

    this.updateVisibility();
    if (this.isSingleColumn()) {
      if (this.itemSelectionIndex >= 0) {
        // Załaduj artykuł w szczegółowym jednokolumnowym widoku
        binding.processAll(element.querySelector(".articlesection"), this.items.getAt(this.itemSelectionIndex));
      }
    } else {
      if (nav.canGoBack && nav.history.backStack[nav.history.backStack.length - 1].location === "/pages/split/split.html") {
        // Skasuj właściwość backstack aby obsłużyć przypinanie,
        // wychodzenie, odpinanie i powrót użytkownika na stronę.
        nav.history.backStack.pop();
      }
      // Jeżeli ta strona ma właściwość selectionIndex,
      // pokaż wybór w obiekcie ListView.
      listView.selection.set(Math.max(this.itemSelectionIndex, 0));
    }

    // Funkcja odbsługująca kliknięcie przycisku aplikacji "Przypnij do ekranu startowego"
    pinButton.onclick = this.createSecondaryTile.bind(this);
  },

  // utwórz dodatkowy kafelek, gdy użytkownik wybierze "Przypnij do ekranu startowego"
  // przycisk w pasku aplikacji
  createSecondaryTile: function () {
    var startScreen = Windows.UI.StartScreen;

    // użyj klucza grupy dla identyfikatora kafelka, potrzebujemy tylko jednego na grupę
    var id = this.group.key;

    // Utwórz dodatkowy kafelek
    var tile = new startScreen.SecondaryTile(id);
    tile.arguments = this.group.title;
    tile.logo = new Windows.Foundation.Uri("ms-appx:///images/logo.png");
    tile.displayName = this.group.title;
    tile.shortName = this.group.title;
    tile.foregroundText = startScreen.ForegroundText.light;
    tile.tileOptions = startScreen.TileOptions.showNameOnLogo;

    // ustaw opcje, aby kafelek był ponownie dodany po instalacji aplikacji na innym komputerze
    //tile.tileOptions = startScreen.TileOptions.copyOnDeployment; 

    // ustaw opcje określające położenie okna z potwierdzeniem powyżej przycisku do przypięcia
    var r = pinButton.getBoundingClientRect();
    var previewRect = { x: r.left, y: r.top, width: r.width, height: r.height };
    var placement = Windows.UI.Popups.Placement.above;

    // dodaj kafelek
    tile.requestCreateForSelectionAsync(previewRect, placement);
  },

  selectionChanged: function (args) {
    var listView = document.body.querySelector(".itemlist").winControl;
    var details;
    var that = this;
    // Domyślnie wybór jest ograniczony do pojedynczego elementu
    listView.selection.getItems().done(function updateDetails(items) {
      if (items.length > 0) {
        that.itemSelectionIndex = items[0].index;
        if (that.isSingleColumn()) {
          // Jeżeli strona jest przypięta lub pionowa, przejdź do nowej strony
          // zawierającej szczegóły wybranych elementów.
          nav.navigate("/pages/split/split.html", { groupKey: that.group.key, selectedIndex: that.itemSelectionIndex });
        }
        else {
          // Jeżeli jest widok pełnoekranowy, zaktualizuj kolumny ze szczegółami nowymi danymi.
          details = document.querySelector(".articlesection");
          binding.processAll(details, items[0].data);
          details.scrollTop = 0;
        }

        that.updateTile(items[0]);
      }
    });
  },

  unload: function () {
    this.items.dispose();
  },

  // zaktualizuj RSS Reader o ostatnio przeczytany element
  updateTile: function (item) {
    // określ szablon, którego chcesz użyć
    var notifications = Windows.UI.Notifications;
    var template = notifications.TileTemplateType.tileWideImageAndText01;

    // pobierz strukturę XML do aktualizacji
    var xml = notifications.TileUpdateManager.getTemplateContent(template);

    // zaktualizuj element tekstowy
    var text = xml.getElementsByTagName("text")[0];
    text.appendChild(xml.createTextNode("Just Read: " + item.data.title));

    // zaktualizuj element z obrazem
    var img = xml.getElementsByTagName("image")[0];
    img.setAttribute("src", "ms-appx:///images/updatelogo.png");
    //img.setAttribute("src", "http://sellsbrothers.com/content/images/sellsbrothers_logo.jpg");
    img.setAttribute("alt", item.data.title);

    // utwórz aktualizację dla mniejszego kafelka
    //var squareTemplate = notifications.TileTemplateType.tileSquareText02;
    var squareTemplate = notifications.TileTemplateType.tileSquarePeekImageAndText01;

    // pobierz strukturę XML do aktualizacji
    var squareXml = notifications.TileUpdateManager.getTemplateContent(squareTemplate);

    // zaktualizuj element tekstowy
    var squareTextElements = squareXml.getElementsByTagName("text");
    squareTextElements[0].appendChild(squareXml.createTextNode("just read"));
    squareTextElements[1].appendChild(squareXml.createTextNode(item.data.title));
    squareTextElements[2].appendChild(squareXml.createTextNode("peeking under"));
    squareTextElements[3].appendChild(squareXml.createTextNode("tiles is fun!"));

    // zaktualizuj element z obrazem (z odwracaniem)
    var squareImgElement = squareXml.getElementsByTagName("image")[0];
    squareImgElement.setAttribute("src", "ms-appx:///images/logo.png");
    squareImgElement.setAttribute("alt", item.data.title);

    // połącz oba szablony
    var bindingNode = xml.importNode(squareXml.getElementsByTagName("binding")[0], true);
    var visualNode = xml.getElementsByTagName("visual")[0];
    visualNode.appendChild(bindingNode);

    // zaplanuj za minutę, wyrażoną w milisekundach
    var delivery = new Date().getTime() + (60 * 1000);

    // utwórz aktualizację
    //var update = new notifications.TileNotification(xml);
    var update = new notifications.ScheduledTileNotification(xml, new Date(delivery));

    // wygaśnięcie po 10 minutach, mierzone w milisekundach
    var expiration = new Date().getTime() + (10 * 60 * 1000);
    update.expirationTime = new Date(expiration);

    // zaktualizuj kafelek
    //notifications.TileUpdateManager.createTileUpdaterForApplication().update(update);
    notifications.TileUpdateManager.createTileUpdaterForApplication().addToSchedule(update);
  },

  // Ta funkcja aktualizuje układ strony w odpowiedzi na zmiany w viewState.
  updateLayout: function (element, viewState, lastViewState) {
    /// <param name="element" domElement="true" />
    /// <param name="viewState" value="Windows.UI.ViewManagement.ApplicationViewState" />
    /// <param name="lastViewState" value="Windows.UI.ViewManagement.ApplicationViewState" />

    var listView = element.querySelector(".itemlist").winControl;
    var firstVisible = listView.indexOfFirstVisible;
    this.updateVisibility();

    var handler = function (e) {
      listView.removeEventListener("contentanimating", handler, false);
      e.preventDefault();
    }

    if (this.isSingleColumn()) {
      listView.selection.clear();
      if (this.itemSelectionIndex >= 0) {
        // Jeżeli aplikacja jest przypięta z widokiem pojedynczej kolumny ze szczegółami,
        // dodaj do właściwości backstack widok jednokolumnowej listy.
        nav.history.current.state = {
          groupKey: this.group.key,
          selectedIndex: this.itemSelectionIndex
        };
        nav.history.backStack.push({
          location: "/pages/split/split.html",
          state: { groupKey: this.group.key }
        });
        element.querySelector(".articlesection").focus();
      } else {
        listView.addEventListener("contentanimating", handler, false);
        listView.indexOfFirstVisible = firstVisible;
        listView.forceLayout();
      }
    } else {
      // Jeżeli strona zostałą odpięta i ma widok dwukolumnowy, usuń wszystkie instancje 
      // splitPage dodane do backstack.
      if (nav.canGoBack && nav.history.backStack[nav.history.backStack.length - 1].location === "/pages/split/split.html") {
        nav.history.backStack.pop();
      }
      if (viewState !== lastViewState) {
        listView.addEventListener("contentanimating", handler, false);
        listView.indexOfFirstVisible = firstVisible;
        listView.forceLayout();
      }

      listView.selection.set(this.itemSelectionIndex >= 0 ? this.itemSelectionIndex : Math.max(firstVisible, 0));
    }
  },

  // Ta funkcja przełącza widok na dwie kolumny na podstawie
  // bieżącego stanu widoku i wyboru elementów.
  updateVisibility: function () {
    var oldPrimary = document.querySelector(".primarycolumn");
    if (oldPrimary) {
      utils.removeClass(oldPrimary, "primarycolumn");
    }
    if (this.isSingleColumn()) {
      if (this.itemSelectionIndex >= 0) {
        utils.addClass(document.querySelector(".articlesection"), "primarycolumn");
        document.querySelector(".articlesection").focus();
      } else {
        utils.addClass(document.querySelector(".itemlistsection"), "primarycolumn");
        document.querySelector(".itemlist").focus();
      }
    } else {
      document.querySelector(".itemlist").focus();
    }
  }
});
})();
