﻿// split.js
(function () {
  "use strict";

  var appViewState = Windows.UI.ViewManagement.ApplicationViewState;
  var binding = WinJS.Binding;
  var nav = WinJS.Navigation;
  var ui = WinJS.UI;
  var utils = WinJS.Utilities;
  var appModel = Windows.ApplicationModel;

  ui.Pages.define("/pages/split/split.html", {

    /// <field type="WinJS.Binding.List" />
    items: null,
    /// <field type="Object" />
    group: null,
    itemSelectionIndex: -1,

    // Ta funkcja sprawdza, czy lista i szczegóły kolumn mają
    // być pokazane na osobnych stronach a nie na sąsiednich.
    isSingleColumn: function () {
      var viewState = Windows.UI.ViewManagement.ApplicationView.value;
      return (viewState === appViewState.snapped || viewState === appViewState.fullScreenPortrait);
    },

    // Ta funkcja jest wywoływana, gdy użytkownik otworzy tę stronę.
    // Umieszcza dane aplikacyjne w elementach strony.
    ready: function (element, options) {
      var listView = element.querySelector(".itemlist").winControl;

    // Zapamiętaj informację o grupie i wyborze,
    // które będą pokazane na stronie
      this.group = (options && options.groupKey) ? Data.resolveGroupReference(options.groupKey) : Data.groups.getAt(0);
      this.items = Data.getItemsFromGroup(this.group);
      this.itemSelectionIndex = (options && "selectedIndex" in options) ? options.selectedIndex : -1;

      element.querySelector("header[role=banner] .pagetitle").textContent = this.group.title;

      // Skonfiguruj obiekt ListView.
      listView.itemDataSource = this.items.dataSource;
      listView.itemTemplate = element.querySelector(".itemtemplate");
      listView.onselectionchanged = this.selectionChanged.bind(this);
      listView.layout = new ui.ListLayout();

      this.updateVisibility();
      if (this.isSingleColumn()) {
        if (this.itemSelectionIndex >= 0) {
          // Załaduj artykuł w szczegółowym jednokolumnowym widoku
          binding.processAll(element.querySelector(".articlesection"), this.items.getAt(this.itemSelectionIndex));
        }
      } else {
        if (nav.canGoBack && nav.history.backStack[nav.history.backStack.length - 1].location === "/pages/split/split.html") {
          // Skasuj właściwość backstack aby obsłużyć przypinanie,
          // wychodzenie, odpinanie i powrót użytkownika na stronę.
          nav.history.backStack.pop();
        }
        // Jeżeli ta strona ma właściwość selectionIndex,
        // pokaż wybór w obiekcie ListView.
        listView.selection.set(Math.max(this.itemSelectionIndex, 0));
      }
    },

    selectionChanged: function (args) {
      var listView = document.body.querySelector(".itemlist").winControl;
      var details;
      var that = this;
      // Domyślnie wybór jest ograniczony do pojedynczego elementu
      listView.selection.getItems().done(function updateDetails(items) {
        if (items.length > 0) {
          that.itemSelectionIndex = items[0].index;
          nav.history.current.state.selectedItem = items[0];
          if (that.isSingleColumn()) {
            // Jeżeli strona jest przypięta lub pionowa, przejdź do nowej strony
            // zawierającej szczegóły wybranych elementów.
            nav.navigate("/pages/split/split.html", { groupKey: that.group.key, selectedIndex: that.itemSelectionIndex });
          } else {
            // Jeżeli jest widok pełnoekranowy, zaktualizuj kolumny ze szczegółami nowymi danymi.
            details = document.querySelector(".articlesection");
            binding.processAll(details, items[0].data);
            details.scrollTop = 0;
          }
        }
      });
    },

    unload: function () {
      this.items.dispose();
    },

    // Ta funkcja aktualizuje układ strony w odpowiedzi na zmiany w viewState.
    updateLayout: function (element, viewState, lastViewState) {
      /// <param name="element" domElement="true" />
      /// <param name="viewState" value="Windows.UI.ViewManagement.ApplicationViewState" />
      /// <param name="lastViewState" value="Windows.UI.ViewManagement.ApplicationViewState" />

      var listView = element.querySelector(".itemlist").winControl;
      var firstVisible = listView.indexOfFirstVisible;
      this.updateVisibility();

      var handler = function (e) {
        listView.removeEventListener("contentanimating", handler, false);
        e.preventDefault();
      }

      if (this.isSingleColumn()) {
        listView.selection.clear();
        if (this.itemSelectionIndex >= 0) {
          // Jeżeli aplikacja jest przypięta z widokiem pojedynczej kolumny ze szczegółami,
          // dodaj do właściwości backstack widok jednokolumnowej listy.
          nav.history.current.state = {
            groupKey: this.group.key,
            selectedIndex: this.itemSelectionIndex
          };
          nav.history.backStack.push({
            location: "/pages/split/split.html",
            state: { groupKey: this.group.key }
          });
          element.querySelector(".articlesection").focus();
        } else {
          listView.addEventListener("contentanimating", handler, false);
          listView.indexOfFirstVisible = firstVisible;
          listView.forceLayout();
        }
      } else {
        // Jeżeli strona zostałą odpięta i ma widok dwukolumnowy, usuń wszystkie instancje 
        // splitPage dodane do backstack.
        if (nav.canGoBack && nav.history.backStack[nav.history.backStack.length - 1].location === "/pages/split/split.html") {
          nav.history.backStack.pop();
        }
        if (viewState !== lastViewState) {
          listView.addEventListener("contentanimating", handler, false);
          listView.indexOfFirstVisible = firstVisible;
          listView.forceLayout();
        }

        listView.selection.set(this.itemSelectionIndex >= 0 ? this.itemSelectionIndex : Math.max(firstVisible, 0));
      }
    },

    // Ta funkcja przełącza widok na dwie kolumny na podstawie
    // bieżącego stanu widoku i wyboru elementów.
    updateVisibility: function () {
      var oldPrimary = document.querySelector(".primarycolumn");
      if (oldPrimary) {
        utils.removeClass(oldPrimary, "primarycolumn");
      }
      if (this.isSingleColumn()) {
        if (this.itemSelectionIndex >= 0) {
          utils.addClass(document.querySelector(".articlesection"), "primarycolumn");
          document.querySelector(".articlesection").focus();
        } else {
          utils.addClass(document.querySelector(".itemlistsection"), "primarycolumn");
          document.querySelector(".itemlist").focus();
        }
      } else {
        document.querySelector(".itemlist").focus();
      }
    }
  });


})();
