﻿// default.js
// Poniższa dokumentacja zawiera wprowadzenie do szablonu Split:
// http://go.microsoft.com/fwlink/?LinkID=232447
(function () {
  "use strict";

  var app = WinJS.Application;
  var activation = Windows.ApplicationModel.Activation;
  var nav = WinJS.Navigation;
  WinJS.strictProcessing();

  app.addEventListener("activated", function (args) {
    if (args.detail.kind === activation.ActivationKind.launch) {
      if (args.detail.previousExecutionState !== activation.ApplicationExecutionState.terminated) {
        // Do zrobienia: Aplikacja została dopiero uruchomiona.
        // Zainicjuj ją tutaj.
      } else {
        // Do zrobienia: Aplikacja zostałą wznowiona po wstrzymaniu.
        // Odtwórz tutaj stan aplikacji.
      }

      // zarejestruj zaplanowane aktualizacje kafelka
      registerTileUpdate();

      if (app.sessionState.history) {
        nav.history = app.sessionState.history;
      }

      args.setPromise(WinJS.UI.processAll().then(function () {
        // jeżeli trafiliśmy tutaj poprzez kafelek dodatkowy
        if (args.detail.tileId !== "App") {

          // umieść w nawigacji główną stronę z przyciskiem wstecz
          if (nav.history.current.initialPlaceholder) {
            nav.history.current = { location: Application.navigator.home };
          }

          // przejdź do strony podziału z odpowiednim kluczem grupy
          var groupKey = args.detail.tileId;
          return nav.navigate("/pages/split/split.html", { groupKey: groupKey });
        }
        else if (nav.location) {
          nav.history.current.initialPlaceholder = true;
          return nav.navigate(nav.location, nav.state);
        }
        else {
          return nav.navigate(Application.navigator.home);
        }
      }));
    }
  });

  app.oncheckpoint = function (args) {
    // Do zrobienia: Aplikacja będzie wstrzymana. Tutaj zapisz stan, który
    // musi być przetrwać wstrzymanie. Jeżeli jakaś operacja asynchroniczna
    // musi być zakończona przed wstrzymaniem aplikacji, wywołaj args.setPromise().
    app.sessionState.history = nav.history;
  };

  app.onsettings = function (e) {
    e.detail.applicationcommands = {
      feedsFlyout: { title: "Kanały", href: "/settings/feeds/feeds.html" },
      aboutFlyout: { title: "O aplikacji", href: "/settings/about/about.html" },
    };

    WinJS.UI.SettingsFlyout.populateSettings(e);
  };

  app.start();

  function registerTileUpdate() {
    var notifications = Windows.UI.Notifications;

    // jak często sprawdzać nowe dane dla kafelka?
    var period = notifications.PeriodicUpdateRecurrence.daily;

    // gdzie są dane dla kafelka?
    //var url = new Windows.Foundation.Uri("http://sellsbrothers.com/win8/tileupdate.xml");

    // uruchom proces
    //var updater = notifications.TileUpdateManager.createTileUpdaterForApplication();
    //updater.startPeriodicUpdate(url, period);

    // gdzie są dane dla kafelka?
    var urls = [
      new Windows.Foundation.Uri("http://sellsbrothers.com/win8/tileupdate1.xml"),
      //new Windows.Foundation.Uri("http://sellsbrothers.com/win8/tileupdate2.xml"),
     // new Windows.Foundation.Uri("http://sellsbrothers.com/win8/tileupdate3.xml"),
      //new Windows.Foundation.Uri("http://sellsbrothers.com/win8/tileupdate4.xml"),
      //new Windows.Foundation.Uri("http://sellsbrothers.com/win8/tileupdate5.xml")
    ];

    // włącz kolejkę powiadomień, gdy aplikacja zostanie zainstalowana
    var updater = notifications.TileUpdateManager.createTileUpdaterForApplication();
    updater.enableNotificationQueue(true);

    // uruchom serię aktualizacji
    updater.startPeriodicUpdateBatch(urls, 1);
  }
})();
