﻿// home.js
(function () {
    "use strict";

    function getWordsFromNumber(i) {
        // spodziewałeś się czegoś bardziej wyszukanego?
        var words = ["zero", "jeden", "dwa", "trzy", "cztery", "pięć", "sześć", "siedem", "osiem", "dziewięć", "dziesięć", "jedenaście", "dawanaście", "trzynaście", "czternaście", "piętnaście", "szesnaście", "siedemnaście", "osiemnaście", "dziewiętnaście", "dwadzieścia", "dwadzieścia jeden", "dwadzieścia dwa", "dwadzieścia trzy", "dwadzieścia cztery", "dwadzieścia pięć", "dwadzieścia sześć", "dwadzieścia siedem", "dwadzieścia osiem", "dwadzieścia dziewięć", "trzydzieści", "trzydzieści jeden", "trzydzieści dwa", "trzydzieści trzy", "trzydzieści cztery", "trzydzieści pięć", "trzydzieści sześć", "trzydzieści siedem", "trzydzieści osiem", "trzydzieści dziewięć", "czterdzieści", "czterdzieści jeden", "czterdzieści dwa", "czterdzieści trzy", "czterdzieści cztery", "czterdzieści pięć", "czterdzieści sześć", "czterdzieści siedem", "czterdzieści osiem", "czterdzieści dziewięć", "piędziesiąt"];
        return words[i];
    }

    // konwertuj wiek na słowa
    window.ageToWords = WinJS.Binding.converter(function (value) {
        return getWordsFromNumber(value);
    })

    WinJS.UI.Pages.define("/pages/home/home.html", {
        ready: function (element, options) {
            var people = [
                // powiadom nasłuchujące bindowania, kiedy obiekty ulegną zmianie
                WinJS.Binding.as({ name: "Jasiek", age: 18, favoriteColor: "czerwony" }),
                WinJS.Binding.as({ name: "Tomek", age: 16, favoriteColor: "zielony" }),
                WinJS.Binding.as({ name: "Krzysiek", age: 42, favoriteColor: "niebieski" }),
            ];

            // binduj aktualną osobę do elementu HTML w sekcji
            var section = element.querySelector("section[role=main]");
            var viewModel = WinJS.Binding.as({ current: 0, person: null });
            WinJS.Binding.processAll(section, viewModel);
            viewModel.bind("current", function (newValue, oldValue) {
                viewModel.person = people[newValue];
            });

            birthdayButton.onclick = function () {
                viewModel.person.age++;
            };

            // bindowanie do poprzedniego obiektu
            previousButton.onclick = function () {
                // ustawienie aktualnego indeksu, bindowanie zajmie się resztą
                viewModel.current =
                (people.length + viewModel.current - 1) % people.length;
            };

            // bindowanie do kolejnego obiektu
            nextButton.onclick = function () {
                // ustalenie aktualnego indeksu, bindowanie zajmie się resztą
                viewModel.current =
                (people.length + viewModel.current + 1) % people.length;
            };
        }
    });
})();
