function dateString(date,string) {
		/* Legenda:
			%Y = 2008
			%y = 08
			%M = Styczeń
			%m = Sty
			%N = 01 (miesiąc)
			%n = 1 (miesiąc)
			%W = Poniedziałek
			%w = Pon
			%D = 05 (dzień miesiąca)
			%d = 5 (dzień miesiąca)
			%O = przyrostek określający numer: 'st' w 1st lub 'th' w 5th
			Przykład: '%W, %d %M, %Y' zwróci tekst typu
			'Poniedziałek, 9 Luty, 2009'
		*/
		var months = ['Styczeń','Luty','Marzec','Kwiecień','Maj',
         	     'Czerwiec','Lipiec','Sierpień','Wrzesień',
         	     'Październik','Listopad','Grudzień'];

		var days = ['Niedziela','Poniedziałek','Wtorek','Środa',
        	    'Czwartek','Piątek','Sobota'];

		var day=date.getDay();
		var year=date.getFullYear();
		var month=date.getMonth();
		var realMonth=month+1;
		var fillMonth = (realMonth<10) ? '0' + realMonth : realMonth;
		var date=date.getDate();
		var fillDate = (date<10) ? '0' + date : date;
		var sfx = ["th","st","nd","rd"];
		var val = date%100;
	  var ordDate = date + (sfx[(val-20)%10] || sfx[val] || sfx[0]);
		
		
		// Rok
		string = string.replace(/%Y/g,year); // 2008
		string = string.replace(/%y/g,year.toString().slice(-2)); //08
		// Miesiąc
		string = string.replace(/%M/g,months[month]); // Styczeń
		string = string.replace(/%m/g,months[month].slice(0,3)); //Sty
		string = string.replace(/%N/g,fillMonth); // 01
		string = string.replace(/%n/g,realMonth); // 1
		// Dzień tygodnia
		string = string.replace(/%W/g,days[day]); // Poniedziałek
		string = string.replace(/%w/g,days[day].slice(0,3)); // Pon
		// Dzień miesiąca
		string = string.replace(/%D/g,fillDate); //05
		string = string.replace(/%d/g,date); // 5
		// Przyrostek porządkowy (na przykład 1st) 
		string = string.replace(/%O/ig,ordDate);
		return string;
	}
	
