//package structure;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * Przykład użycia klasy ArrayList.
 */
// tag::main[]
public class ArrayListDemo {
    public static void main(String[] argv) {
        List<LocalDate> editions = new ArrayList<>();

        // Dodajemy kilka elementów do obiektu ArrayList.
        editions.add(LocalDate.of(2001, 06, 01));
        editions.add(LocalDate.of(2004, 06, 01));
        editions.add(LocalDate.of(2014, 06, 20));

        // Stosujemy starą pętlę 'for', by pobierać z użyciem indeksu.
        System.out.println("Pobieranie z użyciem indeksu:");
        for (int i = 0; i<editions.size(); i++) {
            System.out.printf("Wydanie %d opublikowano %s\n", i + 1, editions.get(i));
        }
        // Używamy zwyczajnej pętli 'for', by uprościć odwołania.
        System.out.println("Zastosowanie interfejsu Iterable:");
        for (LocalDate dt : editions) {
            System.out.println("Wydanie " + dt);
        }
        
    }
}
// end::main[]
